/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum RouteStrategy implements IntValueEnum<RouteStrategy>
{
    ROUND_ROBIN(1),
    RANDOM(2),
    SIMPLE_HASH(3),
    CONSISTENT_HASH(4),
    LOCAL_PRIORITY(5),
    BROADCAST(6);

    private static final Map<Integer, RouteStrategy> MAPPING;
    private final int value;

    private RouteStrategy(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static RouteStrategy of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid route strategy value: " + value);
    }

    static {
        MAPPING = Enums.toMap(RouteStrategy.class, RouteStrategy::value);
    }
}

