/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum RunState implements IntValueEnum<RunState>
{
    WAITING(10, false, false),
    RUNNING(20, false, false),
    PAUSED(30, false, false),
    FINISHED(40, true, false),
    CANCELED(50, true, true);

    public static final List<RunState> RUNNABLE_LIST;
    public static final List<RunState> TERMINABLE_LIST;
    public static final List<RunState> PAUSABLE_LIST;
    private static final Map<Integer, RunState> MAPPING;
    private final int value;
    private final boolean terminal;
    private final boolean failure;

    private RunState(int value, boolean terminal, boolean failure) {
        this.value = value;
        this.terminal = terminal;
        this.failure = failure;
    }

    public int value() {
        return this.value;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public boolean isFailure() {
        return this.failure;
    }

    public static RunState of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid run state value: " + value);
    }

    static {
        RUNNABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)PAUSED));
        TERMINABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)RUNNING), (Object)((Object)PAUSED));
        PAUSABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)RUNNING));
        MAPPING = Enums.toMap(RunState.class, RunState::value);
    }
}

