/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum RunType implements IntValueEnum<RunType>
{
    SCHEDULE(1),
    DEPEND(2),
    RETRY(3),
    MANUAL(4);

    private static final Map<Integer, RunType> MAPPING;
    private final int value;

    private RunType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static RunType of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid run type value: " + value);
    }

    static {
        MAPPING = Enums.toMap(RunType.class, RunType::value);
    }
}

