/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.date.CronExpression;
import cn.ponfee.disjob.common.date.DatePeriods;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.model.PeriodTriggerValue;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public enum TriggerType implements IntValueEnum<TriggerType>
{
    CRON(1, "0/10 * * * * ?"){

        @Override
        public boolean validate(String triggerValue) {
            return CronExpression.isValidExpression((String)triggerValue);
        }

        @Override
        public Date computeNextFireTime(String triggerValue, Date startTime) {
            try {
                return new CronExpression(triggerValue).getNextValidTimeAfter(startTime);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid cron expression: " + triggerValue, e);
            }
        }

        @Override
        public List<Date> computeNextFireTimes(String triggerValue, Date startTime, int count) {
            CronExpression cronExpression;
            ArrayList<Date> result = new ArrayList<Date>(count);
            try {
                cronExpression = new CronExpression(triggerValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid cron expression: " + triggerValue, e);
            }
            while (count-- > 0 && (startTime = cronExpression.getNextValidTimeAfter(startTime)) != null) {
                result.add(startTime);
            }
            return result;
        }
    }
    ,
    ONCE(2, "2000-01-01 00:00:00"){

        @Override
        public boolean validate(String triggerValue) {
            try {
                Dates.toDate((String)triggerValue);
                return true;
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Override
        public Date computeNextFireTime(String triggerValue, Date startTime) {
            try {
                Date dateTime = Dates.toDate((String)triggerValue);
                return dateTime.after(startTime) ? dateTime : null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid once date format: " + triggerValue, e);
            }
        }

        @Override
        public List<Date> computeNextFireTimes(String triggerValue, Date startTime, int count) {
            Date nextFireTime = this.computeNextFireTime(triggerValue, startTime);
            return nextFireTime == null ? Collections.emptyList() : Collections.singletonList(nextFireTime);
        }
    }
    ,
    PERIOD(3, "{\"period\":\"DAILY\", \"start\":\"2000-01-01 00:00:00\", \"step\":1}"){

        @Override
        public boolean validate(String triggerValue) {
            try {
                PeriodTriggerValue conf = (PeriodTriggerValue)Jsons.fromJson((String)triggerValue, PeriodTriggerValue.class);
                return conf != null && conf.isValid();
            }
            catch (Exception ignored) {
                return false;
            }
        }

        @Override
        public Date computeNextFireTime(String triggerValue, Date startTime) {
            return (Date)TriggerType.getOne(this.computeNextFireTimes(triggerValue, startTime, 1));
        }

        @Override
        public List<Date> computeNextFireTimes(String triggerValue, Date startTime, int count) {
            PeriodTriggerValue conf;
            try {
                conf = (PeriodTriggerValue)Jsons.fromJson((String)triggerValue, PeriodTriggerValue.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid period config: " + triggerValue, e);
            }
            Assert.isTrue((conf != null && conf.isValid() ? 1 : 0) != 0, () -> "Invalid period config: " + triggerValue);
            DatePeriods period = conf.getPeriod();
            ArrayList<Date> result = new ArrayList<Date>(count);
            Date next = conf.getStart().after(startTime) ? conf.getStart() : period.next(conf.getStart(), startTime, conf.getStep(), 1).begin();
            result.add(next);
            while (true) {
                int n = --count;
                --count;
                if (n <= 0) break;
                next = period.next(next, conf.getStep(), 1).begin();
                result.add(next);
            }
            return result;
        }
    }
    ,
    DEPEND(4, "3988904755200,3988904755201"){

        @Override
        public boolean validate(String triggerValue) {
            if (StringUtils.isBlank((CharSequence)triggerValue)) {
                return false;
            }
            try {
                long count = Arrays.stream(triggerValue.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(Long::parseLong).filter(e -> e > 0L).count();
                return count > 0L;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }

        @Override
        public Date computeNextFireTime(String triggerValue, Date startTime) {
            throw new UnsupportedOperationException("Trigger type 'DEPEND' unsupported.");
        }

        @Override
        public List<Date> computeNextFireTimes(String triggerValue, Date startTime, int count) {
            throw new UnsupportedOperationException("Trigger type 'DEPEND' unsupported.");
        }
    };

    private static final Map<Integer, TriggerType> MAPPING;
    private final int value;
    private final String example;

    private TriggerType(int value, String example) {
        this.value = value;
        this.example = example;
    }

    public int value() {
        return this.value;
    }

    public String example() {
        return this.example;
    }

    public abstract boolean validate(String var1);

    public abstract Date computeNextFireTime(String var1, Date var2);

    public abstract List<Date> computeNextFireTimes(String var1, Date var2, int var3);

    public static TriggerType of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid trigger type value: " + value);
    }

    private static <T> T getOne(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, () -> "The list expect one size, but actual is " + list.size());
        return list.get(0);
    }

    static {
        MAPPING = Enums.toMap(TriggerType.class, TriggerType::value);
    }
}

