/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle;

import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.common.util.ClassUtils;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.handle.BroadcastJobHandler;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

public class JobHandlerUtils {
    public static void verify(JobHandlerParam param) throws JobException {
        String jobHandler = param.getJobHandler();
        Assert.hasText((String)jobHandler, (String)"Job handler cannot be blank.");
        if (param.getRouteStrategy() == RouteStrategy.BROADCAST) {
            JobHandler<?> handler;
            try {
                handler = JobHandlerUtils.load(jobHandler);
            }
            catch (Throwable e) {
                throw new JobException(JobCodeMsg.INVALID_JOB_HANDLER, e.getMessage());
            }
            if (!(handler instanceof BroadcastJobHandler)) {
                throw new JobException(JobCodeMsg.INVALID_JOB_HANDLER, "Not a broadcast job handler.");
            }
        } else {
            List<SplitTask> tasks;
            try {
                tasks = JobHandlerUtils.split(param);
            }
            catch (Throwable e) {
                throw new JobException(JobCodeMsg.INVALID_JOB_HANDLER, e.getMessage());
            }
            if (CollectionUtils.isEmpty(tasks)) {
                throw new JobException(JobCodeMsg.INVALID_JOB_HANDLER, "Not split any task.");
            }
        }
    }

    public static List<SplitTask> split(JobHandlerParam param) throws JobException {
        try {
            JobHandler<?> jobSplitter = JobHandlerUtils.load(param.getJobHandler());
            List<SplitTask> splitTasks = jobSplitter.split(param.getJobParam());
            if (CollectionUtils.isEmpty(splitTasks)) {
                throw new JobException(JobCodeMsg.SPLIT_JOB_FAILED, "Job split none tasks.");
            }
            return splitTasks;
        }
        catch (JobException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new JobException(JobCodeMsg.SPLIT_JOB_FAILED, "Split job occur error", t);
        }
    }

    public static JobHandler<?> load(String text) throws JobException {
        JobHandler handler = (JobHandler)SpringContextHolder.getPrototypeBean((String)text, JobHandler.class);
        if (handler != null) {
            return handler;
        }
        Class type = ClassUtils.getClass((String)text);
        if (type == null) {
            throw new JobException(JobCodeMsg.LOAD_HANDLER_ERROR, "Illegal class text: " + text);
        }
        if (!JobHandler.class.isAssignableFrom(type) || Modifier.isAbstract(type.getModifiers())) {
            throw new JobException(JobCodeMsg.LOAD_HANDLER_ERROR, "Invalid class type: " + ClassUtils.getName((Class)type) + ", " + text);
        }
        handler = (JobHandler)SpringContextHolder.getPrototypeBean((Class)type);
        if (handler != null) {
            return handler;
        }
        handler = (JobHandler)ClassUtils.newInstance((Class)type);
        SpringContextHolder.autowire((Object)handler);
        return handler;
    }
}

