/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.util.Files;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.handle.Checkpoint;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.util.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.util.Assert;

public class ScriptJobHandler
extends JobHandler<String> {
    private static final String[] DOWNLOAD_PROTOCOL = new String[]{"http", "https", "ftp"};
    private static final String WORKER_DIR = SystemUtils.USER_HOME + "/disjob/worker/scripts/";

    @Override
    public Result<String> execute(Checkpoint checkpoint) throws Exception {
        ScriptParam scriptParam = (ScriptParam)Jsons.fromJson((String)this.task().getTaskParam(), ScriptParam.class);
        Assert.notNull((Object)scriptParam, () -> "Invalid script param: " + scriptParam);
        Assert.notNull((Object)((Object)scriptParam.type), () -> "Script type cannot be null: " + scriptParam);
        scriptParam.type.check();
        Charset charset = Files.charset((String)scriptParam.charset);
        String scriptFileName = scriptParam.type.buildFileName(this.task().getTaskId());
        String scriptPath = ScriptJobHandler.prepareScriptFile(scriptParam.script, scriptFileName, charset);
        Process process = scriptParam.type.exec(scriptPath, scriptParam.envp);
        return ProcessUtils.complete(process, charset, this.task(), this.log);
    }

    private static String prepareScriptFile(String script, String scriptFileName, Charset charset) throws IOException {
        Assert.hasText((String)script, (String)"Script source cannot be empty.");
        String scriptPath = WORKER_DIR + scriptFileName;
        File scriptFile = new File(scriptPath);
        if (scriptFile.exists()) {
            return scriptPath;
        }
        FileUtils.forceMkdirParent((File)scriptFile);
        if (!scriptFile.createNewFile()) {
            throw new IllegalStateException("Create script file failed: " + scriptPath);
        }
        if (StringUtils.startsWithAny((CharSequence)script, (CharSequence[])DOWNLOAD_PROTOCOL)) {
            FileUtils.copyURLToFile((URL)new URL(script), (File)scriptFile, (int)5000, (int)600000);
            return scriptPath;
        }
        FileUtils.write((File)scriptFile, (CharSequence)script, (Charset)charset);
        return scriptPath;
    }

    private static void chmodFile(String scriptPath) throws Exception {
        int code = new ProcessBuilder("/bin/chmod", "755", scriptPath).start().waitFor();
        Assert.state((code == 0 ? 1 : 0) != 0, () -> "Chmod script file '" + scriptPath + "' failed, code: " + code);
    }

    public static class ScriptParam
    implements Serializable {
        private static final long serialVersionUID = 4733248467785540711L;
        private ScriptType type;
        private String charset;
        private String script;
        private String[] envp;

        public ScriptType getType() {
            return this.type;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getScript() {
            return this.script;
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public void setType(ScriptType type) {
            this.type = type;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScriptParam)) {
                return false;
            }
            ScriptParam other = (ScriptParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ScriptType this$type = this.getType();
            ScriptType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
                return false;
            }
            String this$script = this.getScript();
            String other$script = other.getScript();
            if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
                return false;
            }
            return Arrays.deepEquals(this.getEnvp(), other.getEnvp());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScriptParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScriptType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            String $script = this.getScript();
            result = result * 59 + ($script == null ? 43 : $script.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getEnvp());
            return result;
        }

        public String toString() {
            return "ScriptJobHandler.ScriptParam(type=" + (Object)((Object)this.getType()) + ", charset=" + this.getCharset() + ", script=" + this.getScript() + ", envp=" + Arrays.deepToString(this.getEnvp()) + ")";
        }
    }

    public static enum ScriptType {
        CMD{

            @Override
            public void check() {
                Assert.isTrue((boolean)SystemUtils.IS_OS_WINDOWS, () -> "Command script cannot supported os '" + SystemUtils.OS_NAME + "'");
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("cmd_%d.bat", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws IOException {
                return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", scriptPath}, envp);
            }
        }
        ,
        POWERSHELL{

            @Override
            public void check() {
                Assert.isTrue((boolean)SystemUtils.IS_OS_WINDOWS, () -> "Powershell script cannot supported os '" + SystemUtils.OS_NAME + "'");
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("powershell_%d.ps1", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws IOException {
                return Runtime.getRuntime().exec(new String[]{"powershell.exe", scriptPath}, envp);
            }
        }
        ,
        SHELL{

            @Override
            public void check() {
                Assert.isTrue((!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0, () -> "Shell script cannot supported windows os '" + SystemUtils.OS_NAME + "'");
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("shell_%d.sh", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws Exception {
                ScriptJobHandler.chmodFile(scriptPath);
                return Runtime.getRuntime().exec(new String[]{"/bin/sh", scriptPath}, envp);
            }
        }
        ,
        PYTHON{

            @Override
            public void check() {
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("python_%d.py", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws Exception {
                if (!SystemUtils.IS_OS_WINDOWS) {
                    ScriptJobHandler.chmodFile(scriptPath);
                }
                return Runtime.getRuntime().exec(new String[]{"python", scriptPath}, envp);
            }
        };


        public abstract void check();

        public abstract String buildFileName(long var1);

        public abstract Process exec(String var1, String[] var2) throws Exception;
    }
}

