/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.param;

import cn.ponfee.disjob.common.base.LazyLoader;
import cn.ponfee.disjob.common.base.TimingWheel;
import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.util.Bytes;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.Operations;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.handle.TaskExecutor;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.param.ExecuteTaskParamBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.util.Assert;

@JsonDeserialize(using=JacksonDeserializer.class)
public class ExecuteTaskParam
extends ToJsonString
implements TimingWheel.Timing<ExecuteTaskParam>,
Serializable {
    private static final long serialVersionUID = -6493747747321536680L;
    private final AtomicReference<Operations> operation;
    private final long taskId;
    private final long instanceId;
    private final Long wnstanceId;
    private final long triggerTime;
    private final long jobId;
    private final JobType jobType;
    private final RouteStrategy routeStrategy;
    private final int executeTimeout;
    private final String jobHandler;
    private Worker worker;
    private volatile transient TaskExecutor<?> taskExecutor;

    public ExecuteTaskParam(Operations operation, long taskId, long instanceId, Long wnstanceId, long triggerTime, long jobId, JobType jobType, RouteStrategy routeStrategy, int executeTimeout, String jobHandler) {
        Assert.notNull((Object)((Object)operation), (String)"Operation cannot null.");
        Assert.notNull((Object)((Object)routeStrategy), (String)"Route strategy cannot null.");
        Assert.isTrue((wnstanceId == null || wnstanceId > 0L ? 1 : 0) != 0, () -> "Invalid workflow node instance id: " + wnstanceId);
        this.operation = new AtomicReference<Operations>(operation);
        this.taskId = taskId;
        this.instanceId = instanceId;
        this.wnstanceId = wnstanceId;
        this.triggerTime = triggerTime;
        this.jobId = jobId;
        this.jobType = jobType;
        this.routeStrategy = routeStrategy;
        this.executeTimeout = executeTimeout;
        this.jobHandler = jobHandler;
    }

    public static ExecuteTaskParamBuilder builder(SchedInstance instance, Function<Long, SchedJob> jobLoader) {
        return ExecuteTaskParam.builder(instance, (SchedJob)LazyLoader.of(SchedJob.class, jobLoader, (Object)instance.getJobId()));
    }

    public static ExecuteTaskParamBuilder builder(SchedInstance instance, SchedJob schedJob) {
        return new ExecuteTaskParamBuilder(instance, schedJob);
    }

    public AtomicReference<Operations> getOperation() {
        return this.operation;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public long getTriggerTime() {
        return this.triggerTime;
    }

    public long getJobId() {
        return this.jobId;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public RouteStrategy getRouteStrategy() {
        return this.routeStrategy;
    }

    public int getExecuteTimeout() {
        return this.executeTimeout;
    }

    public String getJobHandler() {
        return this.jobHandler;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public boolean updateOperation(Operations expect, Operations update) {
        return this.operation.compareAndSet(expect, update);
    }

    public Operations operation() {
        return this.operation.get();
    }

    public void taskExecutor(TaskExecutor<?> taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void stop() {
        TaskExecutor<?> executor = this.taskExecutor;
        if (executor != null) {
            executor.stop();
        }
    }

    public long timing() {
        return this.triggerTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecuteTaskParam other = (ExecuteTaskParam)o;
        return this.operation.get() == other.operation.get() && this.taskId == other.taskId && this.instanceId == other.instanceId && Objects.equals(this.wnstanceId, other.wnstanceId) && this.triggerTime == other.triggerTime && this.jobId == other.jobId && this.jobType == other.jobType && this.routeStrategy == other.routeStrategy && this.executeTimeout == other.executeTimeout && this.jobHandler.equals(other.jobHandler);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation.get(), this.taskId, this.instanceId, this.wnstanceId, this.triggerTime, this.jobId, this.jobType, this.routeStrategy, this.executeTimeout, this.jobHandler});
    }

    public byte[] serialize() {
        byte[] jobHandlerBytes = this.jobHandler.getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.allocate(47 + jobHandlerBytes.length).put((byte)this.operation.get().ordinal()).putLong(this.taskId).putLong(this.instanceId).putLong(Numbers.nullZero((Long)this.wnstanceId)).putLong(this.triggerTime).putLong(this.jobId).put((byte)this.jobType.ordinal()).put((byte)this.routeStrategy.ordinal()).putInt(this.executeTimeout).put(jobHandlerBytes).array();
    }

    public static ExecuteTaskParam deserialize(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return new ExecuteTaskParam(Operations.values()[buf.get()], buf.getLong(), buf.getLong(), Numbers.zeroNull((long)buf.getLong()), buf.getLong(), buf.getLong(), JobType.values()[buf.get()], RouteStrategy.values()[buf.get()], buf.getInt(), new String(Bytes.remaining((ByteBuffer)buf), StandardCharsets.UTF_8));
    }

    private static ExecuteTaskParam of(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Operations operation = (Operations)EnumUtils.getEnumIgnoreCase(Operations.class, (String)MapUtils.getString(map, (Object)"operation"));
        long taskId = MapUtils.getLongValue(map, (Object)"taskId");
        long instanceId = MapUtils.getLongValue(map, (Object)"instanceId");
        Long wnstanceId = MapUtils.getLong(map, (Object)"wnstanceId");
        long triggerTime = MapUtils.getLongValue(map, (Object)"triggerTime");
        long jobId = MapUtils.getLongValue(map, (Object)"jobId");
        JobType jobType = (JobType)EnumUtils.getEnumIgnoreCase(JobType.class, (String)MapUtils.getString(map, (Object)"jobType"));
        RouteStrategy routeStrategy = (RouteStrategy)EnumUtils.getEnumIgnoreCase(RouteStrategy.class, (String)MapUtils.getString(map, (Object)"routeStrategy"));
        int executeTimeout = MapUtils.getInteger(map, (Object)"executeTimeout");
        String jobHandler = MapUtils.getString(map, (Object)"jobHandler");
        Worker worker = Worker.of((Map)map.get("worker"));
        ExecuteTaskParam param = new ExecuteTaskParam(operation, taskId, instanceId, wnstanceId, triggerTime, jobId, jobType, routeStrategy, executeTimeout, jobHandler);
        param.setWorker(worker);
        return param;
    }

    public static class JacksonDeserializer
    extends JsonDeserializer<ExecuteTaskParam> {
        public ExecuteTaskParam deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return ExecuteTaskParam.of((Map)p.readValueAs(Jsons.MAP_NORMAL));
        }
    }
}

