/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.route;

import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import cn.ponfee.disjob.core.route.ExecutionRouter;
import java.util.List;
import java.util.Objects;

public class LocalPriorityExecutionRouter
extends ExecutionRouter {
    private final ExecutionRouter otherExecutionRouter;

    public LocalPriorityExecutionRouter(ExecutionRouter otherExecutionRouter) {
        this.otherExecutionRouter = Objects.requireNonNull(otherExecutionRouter, "Other execution router cannot be null.");
    }

    @Override
    public RouteStrategy routeStrategy() {
        return RouteStrategy.LOCAL_PRIORITY;
    }

    @Override
    protected Worker doRoute(String group, ExecuteTaskParam param, List<Worker> workers) {
        Worker worker = LocalPriorityExecutionRouter.find(workers, Worker.current());
        return worker != null ? worker : this.otherExecutionRouter.route(group, param, workers);
    }

    private static Worker find(List<Worker> workers, Worker current) {
        if (current == null) {
            return null;
        }
        return workers.stream().filter(current::equalsGroup).findAny().orElse(null);
    }
}

