/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.route;

import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import cn.ponfee.disjob.core.route.ExecutionRouter;
import cn.ponfee.disjob.core.route.count.AtomicCounter;
import cn.ponfee.disjob.core.route.count.JdkAtomicCounter;
import java.util.List;

public class RoundRobinExecutionRouter
extends ExecutionRouter {
    private final AtomicCounter counter;

    public RoundRobinExecutionRouter() {
        this(new JdkAtomicCounter());
    }

    public RoundRobinExecutionRouter(AtomicCounter counter) {
        this.counter = counter;
    }

    @Override
    public RouteStrategy routeStrategy() {
        return RouteStrategy.ROUND_ROBIN;
    }

    @Override
    protected Worker doRoute(String group, ExecuteTaskParam param, List<Worker> workers) {
        return workers.get((int)(this.counter.getAndIncrement() % (long)workers.size()));
    }
}

