/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.route;

import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import cn.ponfee.disjob.core.route.ExecutionRouter;
import java.util.List;
import java.util.function.ToLongFunction;

public class SimpleHashExecutionRouter
extends ExecutionRouter {
    private final ToLongFunction<ExecuteTaskParam> hashFunction;

    public SimpleHashExecutionRouter() {
        this(param -> Math.abs(param.getInstanceId()));
    }

    public SimpleHashExecutionRouter(ToLongFunction<ExecuteTaskParam> hashFunction) {
        this.hashFunction = hashFunction;
    }

    @Override
    public RouteStrategy routeStrategy() {
        return RouteStrategy.SIMPLE_HASH;
    }

    @Override
    protected Worker doRoute(String group, ExecuteTaskParam param, List<Worker> workers) {
        return workers.get((int)(this.hashFunction.applyAsLong(param) % (long)workers.size()));
    }
}

