/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum RetryType implements IntValueEnum<RetryType>
{
    NONE(0, "\u4e0d\u91cd\u8bd5"),
    FAILED(1, "\u91cd\u8bd5\u5931\u8d25\u4efb\u52a1"),
    ALL(2, "\u91cd\u8bd5\u6240\u6709\u4efb\u52a1");

    private static final Map<Integer, RetryType> MAPPING;
    private final int value;
    private final String desc;

    private RetryType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static RetryType of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid retry type value: " + value);
    }

    static {
        MAPPING = Enums.toMap(RetryType.class, RetryType::value);
    }
}

