/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.util.Files;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.handle.Checkpoint;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.util.ProcessUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.util.Assert;

public class CommandJobHandler
extends JobHandler<String> {
    @Override
    public Result<String> execute(Checkpoint checkpoint) throws Exception {
        SchedTask task = this.task();
        Assert.hasText((String)task.getTaskParam(), (String)"Command param cannot be empty.");
        CommandParam commandParam = (CommandParam)Jsons.fromJson((String)task.getTaskParam(), CommandParam.class);
        Assert.notEmpty((Object[])commandParam.cmdarray, (String)"Command array cannot be empty.");
        Charset charset = Files.charset((String)commandParam.charset);
        Process process = Runtime.getRuntime().exec(commandParam.cmdarray, commandParam.envp);
        return ProcessUtils.complete(process, charset, task, this.log);
    }

    public static class CommandParam
    implements Serializable {
        private static final long serialVersionUID = 2079640617453920047L;
        private String[] cmdarray;
        private String[] envp;
        private String charset;

        public String[] getCmdarray() {
            return this.cmdarray;
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCmdarray(String[] cmdarray) {
            this.cmdarray = cmdarray;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandParam)) {
                return false;
            }
            CommandParam other = (CommandParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getCmdarray(), other.getCmdarray())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getEnvp(), other.getEnvp())) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getCmdarray());
            result = result * 59 + Arrays.deepHashCode(this.getEnvp());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            return result;
        }

        public String toString() {
            return "CommandJobHandler.CommandParam(cmdarray=" + Arrays.deepToString(this.getCmdarray()) + ", envp=" + Arrays.deepToString(this.getEnvp()) + ", charset=" + this.getCharset() + ")";
        }
    }
}

