/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.common.util.Enums;

public enum JobCodeMsg implements CodeMsg
{
    INVALID_PARAM(400, "Invalid param."),
    UN_AUTHENTICATED(401, "Un authenticated."),
    KEY_NOT_FOUND(404, "Key not found."),
    LOAD_HANDLER_ERROR(450, "Load job handler error."),
    INVALID_JOB_HANDLER(451, "Invalid job handler."),
    SPLIT_JOB_FAILED(452, "Split job failed."),
    NOT_PAUSABLE_INSTANCE(453, "Not pausable instance state."),
    NOT_CANCELABLE_INSTANCE(454, "Not cancelable instance state."),
    NOT_RESUMABLE_INSTANCE(455, "Not resumable instance state."),
    SERVER_ERROR(500, "Server error."),
    NOT_DISCOVERED_WORKER(550, "Not Discovered worker."),
    JOB_EXECUTE_FAILED(561, "Job execute failed."),
    JOB_EXECUTE_ERROR(562, "Job execute error."),
    PAUSE_TASK_EXCEPTION(563, "Pause task when exception."),
    CANCEL_TASK_EXCEPTION(564, "Cancel task when exception.");

    private final int code;
    private final String msg;

    private JobCodeMsg(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    static {
        Enums.checkDuplicated(JobCodeMsg.class, JobCodeMsg::getCode);
    }
}

