/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.util.Files;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.ProcessUtils;
import cn.ponfee.disjob.core.handle.ExecuteResult;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.Savepoint;
import cn.ponfee.disjob.core.handle.execution.ExecutingTask;
import cn.ponfee.disjob.core.util.JobUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CommandJobHandler
extends JobHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CommandJobHandler.class);
    private Charset charset;
    private Long pid;

    @Override
    protected void onStop() {
        if (this.pid != null) {
            ProcessUtils.killProcess((Long)this.pid, (Charset)this.charset);
        }
    }

    @Override
    public ExecuteResult execute(ExecutingTask executingTask, Savepoint savepoint) throws Exception {
        String taskParam = executingTask.getTaskParam();
        Assert.hasText((String)taskParam, (String)"Command param cannot be empty.");
        CommandParam commandParam = (CommandParam)Jsons.JSON5.readValue(taskParam, CommandParam.class);
        Assert.notEmpty((Object[])commandParam.cmdarray, (String)"Command array cannot be empty.");
        this.charset = Files.charset((String)commandParam.charset);
        Process process = Runtime.getRuntime().exec(commandParam.cmdarray, commandParam.envp);
        this.pid = ProcessUtils.getProcessId((Process)process);
        LOG.info("Command process id: {}, {}", (Object)executingTask.getTaskId(), (Object)this.pid);
        return JobUtils.completeProcess(process, this.charset, executingTask, LOG);
    }

    public static class CommandParam
    implements Serializable {
        private static final long serialVersionUID = 2079640617453920047L;
        private String[] cmdarray;
        private String[] envp;
        private String charset;

        public String[] getCmdarray() {
            return this.cmdarray;
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCmdarray(String[] cmdarray) {
            this.cmdarray = cmdarray;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }
    }
}

