/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.spring.RestTemplateUtils;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.handle.ExecuteResult;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.Savepoint;
import cn.ponfee.disjob.core.handle.execution.ExecutingTask;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpJobHandler
extends JobHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpJobHandler.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private static final RestTemplate REST_TEMPLATE = RestTemplateUtils.create((int)2000, (int)5000, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteResult execute(ExecutingTask executingTask, Savepoint savepoint) {
        HttpJobRequest req = (HttpJobRequest)Jsons.fromJson((String)executingTask.getTaskParam(), HttpJobRequest.class);
        Assert.hasText((String)req.method, (String)"Http method cannot be empty.");
        HttpMethod method = HttpMethod.valueOf((String)req.method.toUpperCase());
        if (RestTemplateUtils.QUERY_PARAM_METHODS.contains(method)) {
            Assert.isNull((Object)req.body, () -> "Http method '" + req.method + "' not supported request body.");
        }
        Assert.hasText((String)req.url, (String)"Http url cannot be empty.");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)req.url);
        MultiValueMap paramsMap = RestTemplateUtils.convertToMultiValueMap((Map)req.params);
        if (paramsMap != null) {
            builder.queryParams(paramsMap);
        }
        URI uri = builder.build().encode().toUri();
        MultiValueMap headersMap = RestTemplateUtils.convertToMultiValueMap((Map)req.headers);
        HttpEntity requestEntity = req.body == null && headersMap == null ? null : new HttpEntity((Object)req.body, headersMap);
        Class<String> responseType = String.class;
        RequestCallback requestCallback = REST_TEMPLATE.httpEntityCallback((Object)requestEntity, responseType);
        ResponseExtractor responseExtractor = REST_TEMPLATE.responseEntityExtractor(responseType);
        try {
            ResponseEntity responseEntity;
            if (HttpJobHandler.equals(req.connectionTimeout, 2000) && HttpJobHandler.equals(req.readTimeout, 5000)) {
                responseEntity = (ResponseEntity)REST_TEMPLATE.execute(uri, method, requestCallback, responseExtractor);
            } else {
                RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
                if (req.connectionTimeout != null) {
                    requestConfigBuilder.setConnectTimeout(req.connectionTimeout.intValue());
                }
                if (req.readTimeout != null) {
                    requestConfigBuilder.setSocketTimeout(req.readTimeout.intValue());
                }
                RestTemplateUtils.HttpContextHolder.bind((RequestConfig)requestConfigBuilder.build());
                try {
                    responseEntity = (ResponseEntity)REST_TEMPLATE.execute(uri, method, requestCallback, responseExtractor);
                }
                finally {
                    RestTemplateUtils.HttpContextHolder.unbind();
                }
            }
            if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful()) {
                return ExecuteResult.success((String)responseEntity.getBody());
            }
            HttpStatus status = null;
            String body = null;
            if (responseEntity != null) {
                status = responseEntity.getStatusCode();
                body = (String)responseEntity.getBody();
            }
            return ExecuteResult.failure(JobCodeMsg.JOB_EXECUTE_FAILED.getCode(), status + ": " + body);
        }
        catch (Throwable t) {
            LOG.error("Http request error: " + executingTask, t);
            return ExecuteResult.failure(JobCodeMsg.JOB_EXECUTE_ERROR.getCode(), Throwables.getRootCauseMessage((Throwable)t));
        }
    }

    private static boolean equals(Integer source, int target) {
        return source == null || source == target;
    }

    public static class HttpJobRequest
    implements Serializable {
        private static final long serialVersionUID = 6173514568347976014L;
        private String method;
        private String url;
        private Map<String, Object> params;
        private Map<String, Object> headers;
        private String body;
        private Integer connectionTimeout;
        private Integer readTimeout;

        public void setMethod(String method) {
            this.method = method;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public Integer getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }
    }
}

