/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.util.Collects;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.base.Server;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.Assert;

@JsonDeserialize(using=JacksonDeserializer.class)
public final class Supervisor
extends Server {
    private static final long serialVersionUID = -1254559108807415145L;
    private final transient String serializedValue;

    public Supervisor(String host, int port) {
        super(host, port);
        this.serializedValue = host + ":" + port;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    @Override
    public String serialize() {
        return this.serializedValue;
    }

    public static Supervisor deserialize(String text) {
        Assert.hasText((String)text, (String)"Serialized text cannot empty.");
        Object[] array = text.split(":");
        String host = (String)Collects.get((Object[])array, (int)0);
        Assert.hasText((String)host, (String)"Supervisor host cannot bank.");
        int port = Numbers.toInt((Object)Collects.get((Object[])array, (int)1));
        return new Supervisor(host, port);
    }

    public static Supervisor current() {
        return Current.current;
    }

    private static Supervisor of(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        String host = MapUtils.getString(map, (Object)"host");
        int port = MapUtils.getIntValue(map, (Object)"port");
        return new Supervisor(host, port);
    }

    private static class Current {
        private static volatile Supervisor current;

        private Current() {
        }

        private static synchronized void set(Supervisor supervisor) {
            if (supervisor == null) {
                throw new AssertionError((Object)"Current supervisor cannot set null.");
            }
            if (current != null) {
                throw new AssertionError((Object)"Current supervisor already set.");
            }
            current = supervisor;
        }
    }

    public static class JacksonDeserializer
    extends JsonDeserializer<Supervisor> {
        public Supervisor deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Supervisor.of((Map)p.readValueAs(Jsons.MAP_NORMAL));
        }
    }
}

