/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.route.count;

import cn.ponfee.disjob.common.spring.RedisKeyRenewal;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.route.count.AtomicCounter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisAtomicCounter
extends AtomicCounter {
    private final String counterRedisKey;
    private final StringRedisTemplate stringRedisTemplate;
    private final RedisKeyRenewal redisKeyRenewal;

    public RedisAtomicCounter(String redisCounterKey, StringRedisTemplate stringRedisTemplate) {
        this.counterRedisKey = "route:counter:" + redisCounterKey;
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisKeyRenewal = new RedisKeyRenewal((RedisTemplate)stringRedisTemplate, this.counterRedisKey);
        if (Boolean.FALSE.equals(stringRedisTemplate.hasKey((Object)this.counterRedisKey))) {
            this.set(1L);
        }
    }

    @Override
    public long get() {
        String ret = (String)this.stringRedisTemplate.opsForValue().get((Object)this.counterRedisKey);
        this.redisKeyRenewal.renewIfNecessary();
        return Numbers.toLong((Object)ret);
    }

    @Override
    public void set(long newValue) {
        this.stringRedisTemplate.opsForValue().set((Object)this.counterRedisKey, (Object)Long.toString(newValue));
        this.redisKeyRenewal.renewIfNecessary();
    }

    @Override
    public long getAndAdd(long delta) {
        Long value = this.stringRedisTemplate.opsForValue().increment((Object)this.counterRedisKey, delta);
        this.redisKeyRenewal.renewIfNecessary();
        return value == null ? 0L : value;
    }
}

