/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.LoggedUncaughtExceptionHandler;
import cn.ponfee.disjob.common.concurrent.Threads;
import com.google.common.base.CaseFormat;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHeartbeatThread
extends Thread
implements Closeable {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int MAX_BUSY_COUNT = 47;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    protected final long heartbeatPeriodMs;

    public AbstractHeartbeatThread(long heartbeatPeriodMs) {
        this.log.info("Heartbeat thread init {}", this.getClass());
        this.heartbeatPeriodMs = heartbeatPeriodMs;
        super.setDaemon(true);
        super.setName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName()) + "_thread");
        super.setPriority(10);
        super.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LoggedUncaughtExceptionHandler.INSTANCE);
    }

    @Override
    public final void run() {
        this.log.info("Heartbeat thread started.");
        try {
            int processedCount = 0;
            while (!this.stopped.get()) {
                boolean isBusyLoop;
                if (super.isInterrupted()) {
                    this.log.error("Thread exit by interrupted.");
                    break;
                }
                long begin = System.currentTimeMillis();
                try {
                    isBusyLoop = this.heartbeat();
                }
                catch (Throwable t) {
                    isBusyLoop = true;
                    this.log.error("Heartbeat occur error, stopped=" + this.stopped, t);
                }
                long end = System.currentTimeMillis();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Heartbeat processed time: {}", (Object)(end - begin));
                }
                if (isBusyLoop) {
                    processedCount = 0;
                    this.doSleep(this.heartbeatPeriodMs - end % this.heartbeatPeriodMs);
                    continue;
                }
                if (++processedCount <= 47) continue;
                this.doSleep(1000L - end % 1000L);
            }
        }
        catch (InterruptedException e) {
            this.log.error("Sleep occur error in loop, stopped=" + this.stopped, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.toStop();
        this.log.info("Heartbeat end.");
    }

    private void doSleep(long sleepTimeMillis) throws InterruptedException {
        Thread.sleep(sleepTimeMillis);
        this.log.debug("Heartbeat sleep time: {}", (Object)sleepTimeMillis);
    }

    public final boolean isStopped() {
        return Threads.isStopped((Thread)this);
    }

    @Override
    public void close() {
        this.doStop(1000L);
    }

    public boolean toStop() {
        return this.stopped.compareAndSet(false, true);
    }

    public void doStop(long joinMillis) {
        this.toStop();
        int count = 10;
        Threads.stopThread((Thread)this, (int)count, (long)(this.heartbeatPeriodMs / (long)count), (long)joinMillis);
    }

    protected abstract boolean heartbeat();
}

