/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.spring.RestTemplateUtils;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.Savepoint;
import cn.ponfee.disjob.core.handle.execution.ExecutingTask;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpJobHandler
extends JobHandler<String> {
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final int DEFAULT_READ_TIMEOUT = 5000;
    private static final RestTemplate REST_TEMPLATE = RestTemplateUtils.buildRestTemplate((int)2000, (int)5000, (Charset)StandardCharsets.UTF_8, (MappingJackson2HttpMessageConverter)RestTemplateUtils.buildJackson2HttpMessageConverter(null));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<String> execute(ExecutingTask executingTask, Savepoint savepoint) {
        HttpJobRequest req = (HttpJobRequest)Jsons.fromJson((String)executingTask.getTaskParam(), HttpJobRequest.class);
        Assert.hasText((String)req.method, (String)"Http method cannot be empty.");
        HttpMethod method = HttpMethod.valueOf((String)req.method.toUpperCase());
        if (RestTemplateUtils.QUERY_PARAM_METHODS.contains(method)) {
            Assert.isNull((Object)req.body, () -> "Http method '" + req.method + "' not supported request body.");
        }
        Assert.hasText((String)req.url, (String)"Http url cannot be empty.");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)req.url);
        MultiValueMap paramsMap = RestTemplateUtils.toMultiValueMap((Map)req.params);
        if (paramsMap != null) {
            builder.queryParams(paramsMap);
        }
        URI uri = builder.build().encode().toUri();
        MultiValueMap headersMap = RestTemplateUtils.toMultiValueMap((Map)req.headers);
        HttpEntity requestEntity = req.body == null && headersMap == null ? null : new HttpEntity((Object)req.body, headersMap);
        Class<String> responseType = String.class;
        RequestCallback requestCallback = REST_TEMPLATE.httpEntityCallback((Object)requestEntity, responseType);
        ResponseExtractor responseExtractor = REST_TEMPLATE.responseEntityExtractor(responseType);
        try {
            ResponseEntity responseEntity;
            if (HttpJobHandler.equals(req.connectionTimeout, 2000) && HttpJobHandler.equals(req.readTimeout, 5000)) {
                responseEntity = (ResponseEntity)REST_TEMPLATE.execute(uri, method, requestCallback, responseExtractor);
            } else {
                RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
                if (req.connectionTimeout != null) {
                    requestConfigBuilder.setConnectTimeout(req.connectionTimeout.intValue());
                }
                if (req.readTimeout != null) {
                    requestConfigBuilder.setSocketTimeout(req.readTimeout.intValue());
                }
                RestTemplateUtils.HttpContextHolder.bind((RequestConfig)requestConfigBuilder.build());
                try {
                    responseEntity = (ResponseEntity)REST_TEMPLATE.execute(uri, method, requestCallback, responseExtractor);
                }
                finally {
                    RestTemplateUtils.HttpContextHolder.unbind();
                }
            }
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return Result.success((Object)responseEntity.getBody());
            }
            return Result.failure((int)JobCodeMsg.JOB_EXECUTE_FAILED.getCode(), (String)("Code: " + responseEntity.getStatusCode() + ", response: " + (String)responseEntity.getBody()));
        }
        catch (Throwable t) {
            this.log.error("Http request failed: " + executingTask, t);
            return Result.failure((int)JobCodeMsg.JOB_EXECUTE_FAILED.getCode(), (String)Throwables.getRootCauseMessage((Throwable)t));
        }
    }

    private static boolean equals(Integer source, int target) {
        return source == null || source == target;
    }

    public static class HttpJobRequest
    implements Serializable {
        private static final long serialVersionUID = 6173514568347976014L;
        private String method;
        private String url;
        private Map<String, Object> params;
        private Map<String, Object> headers;
        private String body;
        private Integer connectionTimeout;
        private Integer readTimeout;

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public Integer getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public void setHeaders(Map<String, Object> headers) {
            this.headers = headers;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public void setConnectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpJobRequest)) {
                return false;
            }
            HttpJobRequest other = (HttpJobRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$connectionTimeout = this.getConnectionTimeout();
            Integer other$connectionTimeout = other.getConnectionTimeout();
            if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
                return false;
            }
            Integer this$readTimeout = this.getReadTimeout();
            Integer other$readTimeout = other.getReadTimeout();
            if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            Map<String, Object> this$headers = this.getHeaders();
            Map<String, Object> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpJobRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $connectionTimeout = this.getConnectionTimeout();
            result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
            Integer $readTimeout = this.getReadTimeout();
            result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            Map<String, Object> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "HttpJobHandler.HttpJobRequest(method=" + this.getMethod() + ", url=" + this.getUrl() + ", params=" + this.getParams() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", connectionTimeout=" + this.getConnectionTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
        }
    }
}

