/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.param;

import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.Operations;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.model.InstanceAttach;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import org.springframework.util.Assert;

public class ExecuteTaskParamBuilder {
    private final SchedInstance instance;
    private final SchedJob job;

    ExecuteTaskParamBuilder(SchedInstance instance, SchedJob schedJob) {
        this.instance = instance;
        this.job = schedJob;
    }

    public ExecuteTaskParam build(Operations ops, long taskId, long triggerTime, Worker worker) {
        String jobHandler;
        if (this.instance.getWnstanceId() != null) {
            Assert.hasText((String)this.instance.getAttach(), () -> "Workflow node instance attach cannot be null: " + this.instance.getInstanceId());
            InstanceAttach attach = (InstanceAttach)Jsons.fromJson((String)this.instance.getAttach(), InstanceAttach.class);
            jobHandler = DAGNode.fromString((String)attach.getCurNode()).getName();
        } else {
            jobHandler = this.job.getJobHandler();
        }
        ExecuteTaskParam param = new ExecuteTaskParam(ops, taskId, this.instance.getInstanceId(), this.instance.getWnstanceId(), triggerTime, this.job.getJobId(), JobType.of(this.job.getJobType()), RouteStrategy.of(this.job.getRouteStrategy()), this.job.getExecuteTimeout(), jobHandler);
        param.setWorker(worker);
        return param;
    }
}

