/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.route;

import cn.ponfee.disjob.common.base.ConsistentHash;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.param.ExecuteTaskParam;
import cn.ponfee.disjob.core.route.ExecutionRouter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ConsistentHashExecutionRouter
extends ExecutionRouter {
    private final Map<String, Pair<List<Worker>, ConsistentHash<Worker>>> cache = new HashMap<String, Pair<List<Worker>, ConsistentHash<Worker>>>();
    private final int virtualCount;
    private final ConsistentHash.HashFunction hashFunction;

    public ConsistentHashExecutionRouter() {
        this(47, ConsistentHash.HashFunction.FNV);
    }

    public ConsistentHashExecutionRouter(int virtualCount, ConsistentHash.HashFunction hashFunction) {
        this.virtualCount = virtualCount;
        this.hashFunction = hashFunction;
    }

    @Override
    public RouteStrategy routeStrategy() {
        return RouteStrategy.CONSISTENT_HASH;
    }

    @Override
    protected Worker doRoute(String group, ExecuteTaskParam param, List<Worker> workers) {
        ConsistentHash<Worker> consistentHashRouter = this.getConsistentHash(group, workers);
        return (Worker)consistentHashRouter.routeNode(Long.toString(param.getInstanceId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsistentHash<Worker> getConsistentHash(String group, List<Worker> workers) {
        Pair<List<Worker>, ConsistentHash<Worker>> pair = this.cache.get(group);
        if (pair != null && pair.getLeft() == workers) {
            return (ConsistentHash)pair.getRight();
        }
        ConsistentHashExecutionRouter consistentHashExecutionRouter = this;
        synchronized (consistentHashExecutionRouter) {
            pair = this.cache.get(group);
            if (pair != null && pair.getLeft() == workers) {
                return (ConsistentHash)pair.getRight();
            }
            int vc = workers.size() == 1 ? 1 : this.virtualCount;
            ConsistentHash router = new ConsistentHash(workers, vc, Worker::serialize, this.hashFunction);
            this.cache.put(group, (Pair<List<Worker>, ConsistentHash<Worker>>)Pair.of(workers, (Object)router));
            return router;
        }
    }
}

