/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.ToJsonString;
import java.io.Serializable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="disjob.retry")
public class RetryProperties
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -2300492906607942870L;
    private int maxCount = 3;
    private int backoffPeriod = 3000;

    public static RetryProperties of(int maxCount, int backoffPeriod) {
        RetryProperties retry = new RetryProperties();
        retry.setMaxCount(maxCount);
        retry.setBackoffPeriod(backoffPeriod);
        return retry;
    }

    public void check() {
        Assert.isTrue((this.maxCount >= 0 ? 1 : 0) != 0, (String)"Retry max count cannot less than 0.");
        Assert.isTrue((this.backoffPeriod > 0 ? 1 : 0) != 0, (String)"Retry backoff period must be greater than 0.");
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getBackoffPeriod() {
        return this.backoffPeriod;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setBackoffPeriod(int backoffPeriod) {
        this.backoffPeriod = backoffPeriod;
    }
}

