/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum MisfireStrategy implements IntValueEnum<MisfireStrategy>
{
    LAST(1, "\u89e6\u53d1\u6700\u8fd1\u4e00\u6b21"),
    DISCARD(2, "\u4e22\u5f03\u6240\u6709"),
    EVERY(3, "\u89e6\u53d1\u6240\u6709");

    private static final Map<Integer, MisfireStrategy> MAPPING;
    private final int value;
    private final String desc;

    private MisfireStrategy(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static MisfireStrategy of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid misfire strategy value: " + value);
    }

    static {
        MAPPING = Enums.toMap(MisfireStrategy.class, MisfireStrategy::value);
    }
}

