/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle;

import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.common.model.Result;

public class ExecuteResult
extends Result.ImmutableResult<Void> {
    private static final long serialVersionUID = -6336359114514174838L;
    private static final ExecuteResult SUCCESS = new ExecuteResult(Result.success().getCode(), Result.success().getMsg());

    private ExecuteResult(int code, String msg) {
        super(code, msg, null);
    }

    public static ExecuteResult success() {
        return SUCCESS;
    }

    public static ExecuteResult success(String msg) {
        return new ExecuteResult(SUCCESS.getCode(), msg);
    }

    public static ExecuteResult failure(CodeMsg cm) {
        return ExecuteResult.failure(cm.getCode(), cm.getMsg());
    }

    public static ExecuteResult failure(int code, String msg) {
        if (code == SUCCESS.getCode()) {
            throw new IllegalStateException("Execute result failure code '" + code + "' cannot be '" + SUCCESS.getCode() + "'.");
        }
        return new ExecuteResult(code, msg);
    }

    public Void getData() {
        throw new UnsupportedOperationException("Execute result unsupported data.");
    }
}

