/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.model;

import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.model.InstanceAttach;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class SchedInstance
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -1457861792948169949L;
    private Long instanceId;
    private Long rnstanceId;
    private Long pnstanceId;
    private Long wnstanceId;
    private Long jobId;
    private Long triggerTime;
    private Integer runType;
    private Integer runState;
    private Date runStartTime;
    private Date runEndTime;
    private Long runDuration;
    private Integer retriedCount;
    private String attach;
    private Integer version;

    public static SchedInstance create(long instanceId, long jobId, RunType runType, long triggerTime, int retriedCount, Date date) {
        SchedInstance instance = new SchedInstance();
        instance.setInstanceId(instanceId);
        instance.setJobId(jobId);
        instance.setRunType(runType.value());
        instance.setTriggerTime(triggerTime);
        instance.setRetriedCount(retriedCount);
        instance.setUpdatedAt(date);
        instance.setCreatedAt(date);
        instance.setRunState(RunState.WAITING.value());
        return instance;
    }

    public long obtainLockInstanceId() {
        return this.wnstanceId != null ? this.wnstanceId : this.instanceId;
    }

    public Long obtainRnstanceId() {
        if (this.rnstanceId != null) {
            return this.rnstanceId;
        }
        if (this.pnstanceId != null) {
            return this.pnstanceId;
        }
        return this.instanceId;
    }

    @Transient
    public boolean isWorkflow() {
        return this.wnstanceId != null;
    }

    @Transient
    public boolean isWorkflowNode() {
        return this.isWorkflow() && !this.wnstanceId.equals(this.instanceId);
    }

    @Transient
    public boolean isWorkflowLead() {
        return this.isWorkflow() && this.wnstanceId.equals(this.instanceId);
    }

    public InstanceAttach parseAttach() {
        if (StringUtils.isBlank((CharSequence)this.attach)) {
            return null;
        }
        return (InstanceAttach)Jsons.fromJson((String)this.attach, InstanceAttach.class);
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getRnstanceId() {
        return this.rnstanceId;
    }

    public Long getPnstanceId() {
        return this.pnstanceId;
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getTriggerTime() {
        return this.triggerTime;
    }

    public Integer getRunType() {
        return this.runType;
    }

    public Integer getRunState() {
        return this.runState;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public Date getRunEndTime() {
        return this.runEndTime;
    }

    public Long getRunDuration() {
        return this.runDuration;
    }

    public Integer getRetriedCount() {
        return this.retriedCount;
    }

    public String getAttach() {
        return this.attach;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setRnstanceId(Long rnstanceId) {
        this.rnstanceId = rnstanceId;
    }

    public void setPnstanceId(Long pnstanceId) {
        this.pnstanceId = pnstanceId;
    }

    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setTriggerTime(Long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public void setRunType(Integer runType) {
        this.runType = runType;
    }

    public void setRunState(Integer runState) {
        this.runState = runState;
    }

    public void setRunStartTime(Date runStartTime) {
        this.runStartTime = runStartTime;
    }

    public void setRunEndTime(Date runEndTime) {
        this.runEndTime = runEndTime;
    }

    public void setRunDuration(Long runDuration) {
        this.runDuration = runDuration;
    }

    public void setRetriedCount(Integer retriedCount) {
        this.retriedCount = retriedCount;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }
}

