/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.param;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.model.SchedJob;
import java.io.Serializable;

public class JobHandlerParam
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -216622646271234535L;
    private String jobGroup;
    private String jobHandler;
    private String jobParam;
    private JobType jobType;
    private RouteStrategy routeStrategy;

    public JobHandlerParam(String jobGroup, String jobHandler, String jobParam, JobType jobType, RouteStrategy routeStrategy) {
        this.jobGroup = jobGroup;
        this.jobHandler = jobHandler;
        this.jobParam = jobParam;
        this.jobType = jobType;
        this.routeStrategy = routeStrategy;
    }

    public static JobHandlerParam from(SchedJob job) {
        return JobHandlerParam.from(job, job.getJobHandler());
    }

    public static JobHandlerParam from(SchedJob job, String jobHandler) {
        return new JobHandlerParam(job.getJobGroup(), jobHandler, job.getJobParam(), JobType.of(job.getJobType()), RouteStrategy.of(job.getRouteStrategy()));
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public String getJobHandler() {
        return this.jobHandler;
    }

    public String getJobParam() {
        return this.jobParam;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public RouteStrategy getRouteStrategy() {
        return this.routeStrategy;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public void setJobHandler(String jobHandler) {
        this.jobHandler = jobHandler;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setRouteStrategy(RouteStrategy routeStrategy) {
        this.routeStrategy = routeStrategy;
    }

    public JobHandlerParam() {
    }
}

