/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.route;

import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.route.BroadcastExecutionRouter;
import cn.ponfee.disjob.core.route.ConsistentHashExecutionRouter;
import cn.ponfee.disjob.core.route.ExecutionRouter;
import cn.ponfee.disjob.core.route.LocalPriorityExecutionRouter;
import cn.ponfee.disjob.core.route.RandomExecutionRouter;
import cn.ponfee.disjob.core.route.RoundRobinExecutionRouter;
import cn.ponfee.disjob.core.route.SimpleHashExecutionRouter;
import java.util.Objects;
import org.springframework.util.Assert;

public class ExecutionRouterRegistrar {
    private static final ExecutionRouter[] REGISTERED_ROUTES = new ExecutionRouter[RouteStrategy.values().length];

    private static synchronized void register0(ExecutionRouter executionRouter) {
        ExecutionRouterRegistrar.REGISTERED_ROUTES[executionRouter.routeStrategy().ordinal()] = executionRouter;
    }

    public static synchronized void register(ExecutionRouter executionRouter) {
        Assert.notNull((Object)executionRouter, (String)"Register execution router cannot be null.");
        Assert.notNull((Object)((Object)executionRouter.routeStrategy()), (String)"Register execution router strategy cannot be null.");
        Assert.isTrue((executionRouter.routeStrategy() != RouteStrategy.BROADCAST ? 1 : 0) != 0, (String)"Cannot register broadcast strategy.");
        ExecutionRouterRegistrar.register0(executionRouter);
    }

    public static ExecutionRouter get(RouteStrategy routeStrategy) {
        Objects.requireNonNull(routeStrategy, "Route strategy cannot be null.");
        return REGISTERED_ROUTES[routeStrategy.ordinal()];
    }

    static {
        ExecutionRouterRegistrar.register0(new RoundRobinExecutionRouter());
        ExecutionRouterRegistrar.register0(new RandomExecutionRouter());
        ExecutionRouterRegistrar.register0(new SimpleHashExecutionRouter());
        ExecutionRouterRegistrar.register0(new ConsistentHashExecutionRouter());
        ExecutionRouterRegistrar.register0(new LocalPriorityExecutionRouter(new RoundRobinExecutionRouter()));
        ExecutionRouterRegistrar.register0(BroadcastExecutionRouter.INSTANCE);
    }
}

