/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.util;

import cn.ponfee.disjob.common.util.NetUtils;
import org.apache.commons.lang3.StringUtils;

public class JobUtils {
    public static String getLocalHost(String specifiedHost) {
        String host = specifiedHost;
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            return JobUtils.validateHost(host, "specified");
        }
        host = System.getProperty("disjob.bound.server.host");
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            return JobUtils.validateHost(host, "jvm");
        }
        host = System.getenv("disjob.bound.server.host");
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            return JobUtils.validateHost(host, "os");
        }
        host = NetUtils.getLocalHost();
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            return JobUtils.validateHost(host, "network");
        }
        throw new IllegalStateException("Not found available server host");
    }

    private static String validateHost(String host, String from) {
        if (NetUtils.isValidLocalHost((String)host)) {
            return host;
        }
        throw new AssertionError((Object)("Invalid bound server host configured " + from + ": " + host));
    }
}

