/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.util;

import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.util.Fields;
import cn.ponfee.disjob.common.util.Files;
import cn.ponfee.disjob.core.handle.ExecuteResult;
import cn.ponfee.disjob.core.handle.execution.ExecutingTask;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);
    private static final long INVALID_PID = -1L;

    public static void destroy(Process process) {
        if (process == null) {
            return;
        }
        try {
            process.destroy();
        }
        catch (Throwable t) {
            LOG.error("Destroy process " + process.getClass().getName() + " error.", t);
        }
    }

    /*
     * Exception decompiling
     */
    public static ExecuteResult complete(Process process, Charset charset, ExecutingTask executingTask, Logger log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int progress(Process process, Charset charset, Logger log) {
        return ProcessUtils.progress(process, charset, arg_0 -> ((Logger)log).info(arg_0), arg_0 -> ((Logger)log).error(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int progress(Process process, Charset charset, Consumer<String> verbose, Consumer<String> error) {
        ForkJoinPool.commonPool().execute(() -> ProcessUtils.read(process.getInputStream(), charset, verbose));
        ForkJoinPool.commonPool().execute(() -> ProcessUtils.read(process.getErrorStream(), charset, error));
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            error.accept("Process execute interrupted: " + ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            int n = -1;
            return n;
        }
        finally {
            if (process != null) {
                try {
                    process.destroy();
                }
                catch (Throwable t) {
                    verbose.accept("Destroy process error: " + ExceptionUtils.getStackTrace((Throwable)t));
                }
            }
        }
    }

    public static Long getProcessId(Process process) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                long handlePointer = (Long)Fields.get((Object)process, (String)"handle");
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handlePointer));
                return Kernel32.INSTANCE.GetProcessId(handle);
            }
            if (SystemUtils.IS_OS_UNIX) {
                Integer pid = (Integer)Fields.get((Object)process, (String)"pid");
                return pid.longValue();
            }
            LOG.error("Get process id unknown os name: {}, {}", (Object)SystemUtils.OS_NAME, (Object)process.getClass().getName());
            return -1L;
        }
        catch (Throwable t) {
            LOG.error("Get process id error.", t);
            return -1L;
        }
    }

    public static void killProcess(Long pid, Charset charset) {
        block30: {
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    List<String> killCommand = Arrays.asList("taskkill", "/PID", String.valueOf(pid), "/F", "/T");
                    Process process = new ProcessBuilder(killCommand).start();
                    try (InputStream input = process.getInputStream();){
                        String verbose = IOUtils.toString((InputStream)input, (Charset)charset);
                        LOG.info("Stop windows process verbose: {}", (Object)verbose);
                    }
                    ProcessUtils.destroy(process);
                    break block30;
                }
                if (SystemUtils.IS_OS_UNIX) {
                    List<String> killCommand = Arrays.asList("/bin/sh", "-c", String.format("ps axo pid,ppid| awk '{ if($2==%d) print$1}'", pid));
                    Process process = new ProcessBuilder(killCommand).start();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));){
                        String childPid;
                        while ((childPid = reader.readLine()) != null) {
                            if (!StringUtils.isNotBlank((CharSequence)childPid)) continue;
                            ProcessUtils.killProcess(Long.valueOf(childPid.trim()), charset);
                        }
                    }
                    ProcessBuilder killProcessBuilder = new ProcessBuilder("kill", "-9", String.valueOf(pid));
                    killProcessBuilder.start().waitFor();
                    LOG.info("Stop unix process id: {}", (Object)pid);
                    ProcessUtils.destroy(process);
                    break block30;
                }
                LOG.error("Stop process id unknown os name: {}, {}", (Object)SystemUtils.OS_NAME, (Object)pid);
            }
            catch (Throwable t) {
                LOG.error("Kill process id '" + pid + "' error.", t);
                Threads.interruptIfNecessary((Throwable)t);
            }
        }
    }

    private static void read(InputStream input, Charset charset, Consumer<String> consumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));){
            String line;
            while (!Thread.currentThread().isInterrupted() && (line = reader.readLine()) != null) {
                consumer.accept(line);
                consumer.accept(Files.SYSTEM_LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            consumer.accept("Read output error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

