/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.common.util.Strings;
import cn.ponfee.disjob.core.base.Server;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.Assert;

@JsonDeserialize(using=JacksonDeserializer.class)
public final class Worker
extends Server {
    private static final long serialVersionUID = 8981019172872301692L;
    private final String group;
    private final String workerId;
    private final transient String serializedValue;

    public Worker(String group, String workerId, String host, int port) {
        super(host, port);
        Assert.isTrue((!workerId.contains(":") ? 1 : 0) != 0, (String)"Worker id cannot contains symbol ':'");
        Assert.isTrue((!group.contains(":") ? 1 : 0) != 0, (String)"Group name cannot contains symbol ':'");
        this.group = Strings.requireNonBlank((String)group.trim());
        this.workerId = workerId;
        this.serializedValue = group + ":" + workerId + ":" + host + ":" + port;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        Worker other = (Worker)o;
        return super.equals(other) && this.group.equals(other.group) && this.workerId.equals(other.workerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.workerId, this.host, this.port);
    }

    @Override
    public String serialize() {
        return this.serializedValue;
    }

    public static Worker deserialize(String text) {
        Assert.hasText((String)text, (String)"Serialized text cannot empty.");
        Object[] array = text.split(":");
        String group = (String)Collects.get((Object[])array, (int)0);
        Assert.hasText((String)group, (String)"Worker group cannot bank.");
        String workerId = (String)Collects.get((Object[])array, (int)1);
        Assert.hasText((String)workerId, (String)"Worker id cannot bank.");
        String host = (String)Collects.get((Object[])array, (int)2);
        Assert.hasText((String)host, (String)"Worker host cannot bank.");
        int port = Numbers.toInt((Object)Collects.get((Object[])array, (int)3));
        return new Worker(group, workerId, host, port);
    }

    public String getGroup() {
        return this.group;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public boolean matchesGroup(String taskGroup) {
        return this.group.equals(taskGroup);
    }

    public boolean sameWorker(Worker other) {
        return super.equals(other) && this.matchesGroup(other.group);
    }

    public static Worker current() {
        return Current.current;
    }

    public static boolean isCurrent(Worker worker) {
        return worker != null && worker.equals(Worker.current());
    }

    public static Worker of(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        String group = MapUtils.getString(map, (Object)"group");
        String workerId = MapUtils.getString(map, (Object)"workerId");
        String host = MapUtils.getString(map, (Object)"host");
        int port = MapUtils.getIntValue(map, (Object)"port");
        return new Worker(group, workerId, host, port);
    }

    private static class Current {
        private static volatile Worker current;

        private Current() {
        }

        private static synchronized void set(Worker worker) {
            if (worker == null) {
                throw new AssertionError((Object)"Current worker cannot set null.");
            }
            if (current != null) {
                throw new AssertionError((Object)"Current worker already set.");
            }
            current = worker;
        }
    }

    public static class JacksonDeserializer
    extends JsonDeserializer<Worker> {
        public Worker deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Worker.of((Map)p.readValueAs(Jsons.MAP_NORMAL));
        }
    }
}

