/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum JobType implements IntValueEnum<JobType>
{
    GENERAL(1, "\u5e38\u89c4"),
    WORKFLOW(2, "\u5de5\u4f5c\u6d41(DAG)");

    private static final Map<Integer, JobType> MAPPING;
    private final int value;
    private final String desc;

    private JobType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public static JobType of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid job type value: " + value);
    }

    static {
        MAPPING = Enums.toMap(JobType.class, JobType::value);
    }
}

