/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle;

import cn.ponfee.disjob.common.dag.DAGExpressionParser;
import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.common.util.ClassUtils;
import cn.ponfee.disjob.common.util.Predicates;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.exception.JobRuntimeException;
import cn.ponfee.disjob.core.handle.BroadcastJobHandler;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.param.JobHandlerParam;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

public class JobHandlerUtils {
    public static void verify(JobHandlerParam param) throws JobException {
        Set<String> jobHandlers;
        Assert.hasText((String)param.getJobHandler(), (String)"Job handler cannot be blank.");
        if (param.getJobType() == JobType.WORKFLOW) {
            jobHandlers = new DAGExpressionParser(param.getJobHandler()).parse().nodes().stream().filter(Predicates.not(DAGNode::isStartOrEnd)).map(DAGNode::getName).collect(Collectors.toSet());
            Assert.notEmpty(jobHandlers, () -> "Invalid workflow job handler: " + param.getJobHandler());
        } else {
            jobHandlers = Collections.singleton(param.getJobHandler());
        }
        for (String jobHandler : jobHandlers) {
            if (param.getRouteStrategy() == RouteStrategy.BROADCAST) {
                try {
                    JobHandler handler = JobHandlerUtils.load(jobHandler);
                    Assert.isTrue((boolean)(handler instanceof BroadcastJobHandler), () -> "Not a broadcast job handler: " + jobHandler);
                    continue;
                }
                catch (JobException | JobRuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new JobException(JobCodeMsg.INVALID_JOB_HANDLER, e.getMessage());
                }
            }
            try {
                param.setJobHandler(jobHandler);
                Assert.notEmpty(JobHandlerUtils.split(param), () -> "Not split any task: " + jobHandler);
            }
            catch (JobException | JobRuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JobException(JobCodeMsg.INVALID_JOB_HANDLER, e.getMessage());
            }
        }
    }

    public static List<SplitTask> split(JobHandlerParam param) throws JobException {
        try {
            JobHandler jobSplitter = JobHandlerUtils.load(param.getJobHandler());
            List<SplitTask> splitTasks = jobSplitter.split(param.getJobParam());
            if (CollectionUtils.isEmpty(splitTasks)) {
                throw new JobException(JobCodeMsg.SPLIT_JOB_FAILED, "Job split none tasks.");
            }
            return splitTasks;
        }
        catch (JobException | JobRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new JobException(JobCodeMsg.SPLIT_JOB_FAILED, "Split job occur error", t);
        }
    }

    public static JobHandler load(String text) throws JobException {
        JobHandler handler = (JobHandler)SpringContextHolder.getPrototypeBean((String)text, JobHandler.class);
        if (handler != null) {
            return handler;
        }
        Class type = ClassUtils.getClass((String)text);
        if (type == null) {
            throw new JobException(JobCodeMsg.LOAD_HANDLER_ERROR, "Illegal job handler: " + text);
        }
        if (!JobHandler.class.isAssignableFrom(type) || Modifier.isAbstract(type.getModifiers())) {
            throw new JobException(JobCodeMsg.LOAD_HANDLER_ERROR, "Invalid job handler: " + ClassUtils.getName((Class)type) + ", " + text);
        }
        handler = (JobHandler)SpringContextHolder.getPrototypeBean((Class)type);
        if (handler != null) {
            return handler;
        }
        handler = (JobHandler)ClassUtils.newInstance((Class)type);
        SpringContextHolder.autowire((Object)handler);
        return handler;
    }
}

