/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.util.Files;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.ProcessUtils;
import cn.ponfee.disjob.core.handle.ExecuteResult;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.Savepoint;
import cn.ponfee.disjob.core.handle.execution.ExecutingTask;
import cn.ponfee.disjob.core.util.JobUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CommandJobHandler
extends JobHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CommandJobHandler.class);
    private Charset charset;
    private Long pid;

    @Override
    protected void onStop() {
        if (this.pid != null) {
            ProcessUtils.killProcess((Long)this.pid, (Charset)this.charset);
        }
    }

    @Override
    public ExecuteResult execute(ExecutingTask executingTask, Savepoint savepoint) throws Exception {
        String taskParam = executingTask.getTaskParam();
        Assert.hasText((String)taskParam, (String)"Command param cannot be empty.");
        CommandParam commandParam = (CommandParam)Jsons.JSON5.readValue(taskParam, CommandParam.class);
        Assert.notEmpty((Object[])commandParam.cmdarray, (String)"Command array cannot be empty.");
        this.charset = Files.charset((String)commandParam.charset);
        Process process = Runtime.getRuntime().exec(commandParam.cmdarray, commandParam.envp);
        this.pid = ProcessUtils.getProcessId((Process)process);
        LOG.info("Command process id: {} | {}", (Object)executingTask.getTaskId(), (Object)this.pid);
        return JobUtils.completeProcess(process, this.charset, executingTask, LOG);
    }

    public static class CommandParam
    implements Serializable {
        private static final long serialVersionUID = 2079640617453920047L;
        private String[] cmdarray;
        private String[] envp;
        private String charset;

        public String[] getCmdarray() {
            return this.cmdarray;
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCmdarray(String[] cmdarray) {
            this.cmdarray = cmdarray;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandParam)) {
                return false;
            }
            CommandParam other = (CommandParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getCmdarray(), other.getCmdarray())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getEnvp(), other.getEnvp())) {
                return false;
            }
            String this$charset = this.getCharset();
            String other$charset = other.getCharset();
            return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getCmdarray());
            result = result * 59 + Arrays.deepHashCode(this.getEnvp());
            String $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
            return result;
        }

        public String toString() {
            return "CommandJobHandler.CommandParam(cmdarray=" + Arrays.deepToString(this.getCmdarray()) + ", envp=" + Arrays.deepToString(this.getEnvp()) + ", charset=" + this.getCharset() + ")";
        }
    }
}

