/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.model;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.core.enums.CollidedStrategy;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.MisfireStrategy;
import cn.ponfee.disjob.core.enums.RetryType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.TriggerType;
import com.google.common.math.IntMath;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class SchedJob
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -1595287180906247896L;
    private Long jobId;
    private String jobGroup;
    private String jobName;
    private Integer jobType;
    private Integer jobState;
    private String jobHandler;
    private String jobParam;
    private Integer retryType;
    private Integer retryCount;
    private Integer retryInterval;
    private Date startTime;
    private Date endTime;
    private Integer triggerType;
    private String triggerValue;
    private Integer executeTimeout;
    private Integer collidedStrategy;
    private Integer misfireStrategy;
    private Integer routeStrategy;
    private Long lastTriggerTime;
    private Long nextTriggerTime;
    private Date nextScanTime;
    private Integer failedScanCount;
    private String remark;
    private Boolean deleted;
    private Integer version;
    private String updatedBy;
    private String createdBy;

    public Long obtainNextTriggerTime() {
        if (this.nextTriggerTime == null || this.endTime == null) {
            return this.nextTriggerTime;
        }
        return this.nextTriggerTime > this.endTime.getTime() ? null : this.nextTriggerTime;
    }

    public void verifyBeforeAdd() {
        TriggerType type = TriggerType.of(this.triggerType);
        if (!type.validate(this.triggerValue)) {
            throw new IllegalArgumentException("Invalid trigger value: " + this.triggerType + ", " + this.triggerValue);
        }
        Assert.isTrue((StringUtils.length((CharSequence)this.triggerValue) <= 255 ? 1 : 0) != 0, (String)"triggerValue length cannot exceed 255.");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.jobGroup), (String)"jobGroup cannot be blank.");
        Assert.isTrue((StringUtils.length((CharSequence)this.jobGroup) <= 30 ? 1 : 0) != 0, (String)"jobGroup length cannot exceed 30.");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.jobName), (String)"jobName cannot be blank.");
        Assert.isTrue((StringUtils.length((CharSequence)this.jobName) <= 60 ? 1 : 0) != 0, (String)"jobName length cannot exceed 60.");
        Assert.hasText((String)this.jobHandler, (String)"Job handler cannot be empty.");
        Assert.isTrue((StringUtils.length((CharSequence)this.remark) <= 255 ? 1 : 0) != 0, (String)"remark length cannot exceed 255.");
        this.triggerValue = this.triggerValue.trim();
        this.jobGroup = this.jobGroup.trim();
        this.jobName = this.jobName.trim();
        this.jobHandler = this.jobHandler.trim();
        this.remark = this.remark == null ? "" : this.remark.trim();
    }

    public void verifyBeforeUpdate() {
        Assert.isTrue((this.jobId != null && this.jobId > 0L ? 1 : 0) != 0, () -> "Invalid jobId: " + this.jobId);
        Assert.isTrue((this.version != null && this.version > 0 ? 1 : 0) != 0, () -> "Invalid version: " + this.version);
        this.verifyBeforeAdd();
    }

    public void checkAndDefaultSetting() {
        if (this.jobState == null) {
            this.jobState = JobState.DISABLE.value();
        }
        if (this.jobType == null) {
            this.jobType = JobType.GENERAL.value();
        }
        if (this.retryType == null) {
            this.retryType = RetryType.NONE.value();
        }
        if (RetryType.of(this.retryType) == RetryType.NONE) {
            if (this.retryCount == null) {
                this.retryCount = 0;
            }
            if (this.retryInterval == null) {
                this.retryInterval = 0;
            }
            Assert.isTrue((this.retryCount == 0 ? 1 : 0) != 0, (String)"Retry count cannot set if none retry.");
            Assert.isTrue((this.retryInterval == 0 ? 1 : 0) != 0, (String)"Retry interval cannot set if none retry.");
        } else {
            Assert.isTrue((this.retryCount != null && this.retryCount > 0 ? 1 : 0) != 0, (String)"Retry count must set if retry.");
            Assert.isTrue((this.retryInterval != null && this.retryInterval > 0 ? 1 : 0) != 0, (String)"Retry interval must set if retry.");
        }
        if (this.executeTimeout == null) {
            this.executeTimeout = 0;
        }
        if (this.collidedStrategy == null) {
            this.collidedStrategy = CollidedStrategy.CONCURRENT.value();
        }
        if (this.misfireStrategy == null) {
            this.misfireStrategy = MisfireStrategy.LAST.value();
        }
        if (this.routeStrategy == null) {
            this.routeStrategy = RouteStrategy.ROUND_ROBIN.value();
        }
        JobState.of(this.jobState);
        JobType.of(this.jobType);
        Assert.isTrue((this.executeTimeout >= 0 ? 1 : 0) != 0, () -> "Invalid execute timeout: " + this.executeTimeout);
        CollidedStrategy.of(this.collidedStrategy);
        MisfireStrategy.of(this.misfireStrategy);
        RouteStrategy.of(this.routeStrategy);
        if (this.startTime != null && this.endTime != null && this.startTime.after(this.endTime)) {
            throw new IllegalArgumentException("Invalid time range: [" + Dates.format((Date)this.startTime) + " ~ " + Dates.format((Date)this.endTime) + "]");
        }
        if (this.jobParam == null) {
            this.jobParam = "";
        }
    }

    public int incrementAndGetFailedScanCount() {
        SchedJob schedJob = this;
        schedJob.failedScanCount = schedJob.failedScanCount + 1;
        return schedJob.failedScanCount;
    }

    public boolean retryable(RunState runState, int retriedCount) {
        Assert.state((boolean)runState.isTerminal(), (String)"Run state must be terminated.");
        if (!runState.isFailure()) {
            return false;
        }
        return !RetryType.NONE.equals(this.retryType) && retriedCount < this.retryCount;
    }

    public long computeRetryTriggerTime(int failCount, Date current) {
        Assert.isTrue((!RetryType.NONE.equals(this.retryType) ? 1 : 0) != 0, () -> "Sched job '" + this.jobId + "' retry type is NONE.");
        Assert.isTrue((this.retryCount > 0 ? 1 : 0) != 0, () -> "Sched job '" + this.jobId + "' retry count must greater than 0, but actual " + this.retryCount);
        Assert.isTrue((failCount <= this.retryCount ? 1 : 0) != 0, () -> "Sched job '" + this.jobId + "' retried " + failCount + " exceed " + this.retryCount + " limit.");
        return current.getTime() + (long)this.retryInterval.intValue() * (long)IntMath.pow((int)failCount, (int)2);
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getJobGroup() {
        return this.jobGroup;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Integer getJobType() {
        return this.jobType;
    }

    public Integer getJobState() {
        return this.jobState;
    }

    public String getJobHandler() {
        return this.jobHandler;
    }

    public String getJobParam() {
        return this.jobParam;
    }

    public Integer getRetryType() {
        return this.retryType;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getTriggerType() {
        return this.triggerType;
    }

    public String getTriggerValue() {
        return this.triggerValue;
    }

    public Integer getExecuteTimeout() {
        return this.executeTimeout;
    }

    public Integer getCollidedStrategy() {
        return this.collidedStrategy;
    }

    public Integer getMisfireStrategy() {
        return this.misfireStrategy;
    }

    public Integer getRouteStrategy() {
        return this.routeStrategy;
    }

    public Long getLastTriggerTime() {
        return this.lastTriggerTime;
    }

    public Long getNextTriggerTime() {
        return this.nextTriggerTime;
    }

    public Date getNextScanTime() {
        return this.nextScanTime;
    }

    public Integer getFailedScanCount() {
        return this.failedScanCount;
    }

    public String getRemark() {
        return this.remark;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }

    public void setJobState(Integer jobState) {
        this.jobState = jobState;
    }

    public void setJobHandler(String jobHandler) {
        this.jobHandler = jobHandler;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public void setRetryType(Integer retryType) {
        this.retryType = retryType;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public void setRetryInterval(Integer retryInterval) {
        this.retryInterval = retryInterval;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }

    public void setTriggerValue(String triggerValue) {
        this.triggerValue = triggerValue;
    }

    public void setExecuteTimeout(Integer executeTimeout) {
        this.executeTimeout = executeTimeout;
    }

    public void setCollidedStrategy(Integer collidedStrategy) {
        this.collidedStrategy = collidedStrategy;
    }

    public void setMisfireStrategy(Integer misfireStrategy) {
        this.misfireStrategy = misfireStrategy;
    }

    public void setRouteStrategy(Integer routeStrategy) {
        this.routeStrategy = routeStrategy;
    }

    public void setLastTriggerTime(Long lastTriggerTime) {
        this.lastTriggerTime = lastTriggerTime;
    }

    public void setNextTriggerTime(Long nextTriggerTime) {
        this.nextTriggerTime = nextTriggerTime;
    }

    public void setNextScanTime(Date nextScanTime) {
        this.nextScanTime = nextScanTime;
    }

    public void setFailedScanCount(Integer failedScanCount) {
        this.failedScanCount = failedScanCount;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}

