/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.common.util.Strings;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.exception.AuthenticationException;
import cn.ponfee.disjob.core.param.worker.AuthenticationParam;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

@JsonSerialize(using=JacksonSerializer.class)
@JsonDeserialize(using=JacksonDeserializer.class)
public class Worker
extends Server {
    private static final long serialVersionUID = 8981019172872301692L;
    private final String group;
    private final String workerId;
    private final transient String serializedValue;

    public Worker(String group, String workerId, String host, int port) {
        super(host, port);
        Assert.isTrue((!group.contains(":") ? 1 : 0) != 0, (String)"Group cannot contains symbol ':'");
        Assert.isTrue((!workerId.contains(":") ? 1 : 0) != 0, (String)"Worker id cannot contains symbol ':'");
        Assert.isTrue((!host.contains(":") ? 1 : 0) != 0, (String)"Host cannot contains symbol ':'");
        this.group = Strings.requireNonBlank((String)group.trim());
        this.workerId = workerId;
        this.serializedValue = group + ":" + workerId + ":" + host + ":" + port;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Worker) || !super.equals(o)) {
            return false;
        }
        Worker other = (Worker)o;
        return this.group.equals(other.group) && this.workerId.equals(other.workerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.workerId, this.host, this.port);
    }

    @Override
    public String serialize() {
        return this.serializedValue;
    }

    public String getGroup() {
        return this.group;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public boolean matchesGroup(String taskGroup) {
        return this.group.equals(taskGroup);
    }

    public boolean sameWorker(Worker other) {
        return super.equals(other) && this.matchesGroup(other.group);
    }

    public static Worker deserialize(byte[] bytes, Charset charset) {
        return Worker.deserialize(new String(bytes, charset));
    }

    public static Worker deserialize(String text) {
        Assert.hasText((String)text, (String)"Serialized text cannot empty.");
        Object[] array = text.split(":");
        String group = (String)Collects.get((Object[])array, (int)0);
        Assert.hasText((String)group, (String)"Worker group cannot bank.");
        String workerId = (String)Collects.get((Object[])array, (int)1);
        Assert.hasText((String)workerId, (String)"Worker id cannot bank.");
        String host = (String)Collects.get((Object[])array, (int)2);
        Assert.hasText((String)host, (String)"Worker host cannot bank.");
        int port = Numbers.toInt((Object)Collects.get((Object[])array, (int)3));
        return new Worker(group, workerId, host, port);
    }

    public static Current current() {
        return Current.instance;
    }

    public static abstract class Current
    extends Worker {
        private static final long serialVersionUID = -480329874106279202L;
        private static volatile Current instance = null;
        private final LocalDateTime startupAt;

        private Current(String group, String workerId, String host, int port) {
            super(group, workerId, host, port);
            SingletonClassConstraint.constrain(Current.class);
            this.startupAt = LocalDateTime.now();
        }

        public LocalDateTime getStartupAt() {
            return this.startupAt;
        }

        public abstract Map<String, String> authenticationHeaders();

        public abstract void authenticate(AuthenticationParam var1);

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        private static synchronized Current create(final String group, String workerId, String host, int port, final String workerToken0, final String supervisorToken0) {
            if (instance != null) {
                throw new Error("Current worker already set.");
            }
            instance = new Current(group, workerId, host, port){
                private static final long serialVersionUID = 7553139562459109482L;
                private final Map<String, String> authenticateHeaders;
                private final String supervisorToken;
                {
                    super(group2, workerId, host, port);
                    this.authenticateHeaders = StringUtils.isBlank((CharSequence)workerToken0) ? Collections.singletonMap("X-Disjob-Group", group) : ImmutableMap.of((Object)"X-Disjob-Group", (Object)group, (Object)"X-Disjob-Token", (Object)workerToken0.trim());
                    this.supervisorToken = StringUtils.isBlank((CharSequence)supervisorToken0) ? null : supervisorToken0.trim();
                }

                @Override
                public Map<String, String> authenticationHeaders() {
                    return this.authenticateHeaders;
                }

                @Override
                public void authenticate(AuthenticationParam param) {
                    if (this.supervisorToken != null && !this.supervisorToken.equals(param.getSupervisorToken())) {
                        throw new AuthenticationException("Authenticate failed.");
                    }
                }
            };
            return instance;
        }
    }

    public static class JacksonDeserializer
    extends JsonDeserializer<Worker> {
        public Worker deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Worker.deserialize(p.getText());
        }
    }

    public static class JacksonSerializer
    extends JsonSerializer<Worker> {
        public void serialize(Worker value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.serialize());
            }
        }
    }
}

