/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.handle.impl;

import cn.ponfee.disjob.common.util.Files;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.ProcessUtils;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.exception.JobRuntimeException;
import cn.ponfee.disjob.core.handle.ExecuteResult;
import cn.ponfee.disjob.core.handle.JobHandler;
import cn.ponfee.disjob.core.handle.Savepoint;
import cn.ponfee.disjob.core.handle.execution.ExecutingTask;
import cn.ponfee.disjob.core.util.JobUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ScriptJobHandler
extends JobHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptJobHandler.class);
    private static final String[] DOWNLOAD_PROTOCOL = new String[]{"http://", "https://", "ftp://"};
    private static final String WORKER_SCRIPT_DIR = SystemUtils.USER_HOME + "/disjob/worker/scripts/";
    private Charset charset;
    private Long pid;

    @Override
    protected void onStop() {
        if (this.pid != null) {
            ProcessUtils.killProcess((Long)this.pid, (Charset)this.charset);
        }
    }

    @Override
    public ExecuteResult execute(ExecutingTask executingTask, Savepoint savepoint) throws Exception {
        ScriptParam scriptParam = (ScriptParam)Jsons.JSON5.readValue(executingTask.getTaskParam(), ScriptParam.class);
        Assert.notNull((Object)scriptParam, () -> "Invalid script param: " + scriptParam);
        Assert.notNull((Object)((Object)scriptParam.type), () -> "Script type cannot be null: " + scriptParam);
        scriptParam.type.check();
        this.charset = Files.charset((String)scriptParam.charset);
        String scriptFileName = scriptParam.type.buildFileName(executingTask.getTaskId());
        String scriptPath = ScriptJobHandler.prepareScriptFile(scriptParam.script, scriptFileName, this.charset);
        Process process = scriptParam.type.exec(scriptPath, scriptParam.envp);
        this.pid = ProcessUtils.getProcessId((Process)process);
        LOG.info("Script process id: {}, {}", (Object)executingTask.getTaskId(), (Object)this.pid);
        return JobUtils.completeProcess(process, this.charset, executingTask, LOG);
    }

    private static String prepareScriptFile(String script, String scriptFileName, Charset charset) throws IOException {
        Assert.hasText((String)script, (String)"Script source cannot be empty.");
        String scriptPath = WORKER_SCRIPT_DIR + scriptFileName;
        File scriptFile = new File(scriptPath);
        if (scriptFile.exists()) {
            return scriptPath;
        }
        FileUtils.forceMkdirParent((File)scriptFile);
        if (!scriptFile.createNewFile()) {
            throw new JobRuntimeException(JobCodeMsg.JOB_EXECUTE_ERROR, "Create script file failed: " + scriptPath);
        }
        if (StringUtils.startsWithAny((CharSequence)script, (CharSequence[])DOWNLOAD_PROTOCOL)) {
            FileUtils.copyURLToFile((URL)new URL(script), (File)scriptFile, (int)5000, (int)600000);
            return scriptPath;
        }
        FileUtils.write((File)scriptFile, (CharSequence)script, (Charset)charset);
        return scriptPath;
    }

    private static void chmodFile(String scriptPath) throws Exception {
        int code = new ProcessBuilder("/bin/chmod", "755", scriptPath).start().waitFor();
        Assert.state((code == 0 ? 1 : 0) != 0, () -> "Chmod script file '" + scriptPath + "' failed, code: " + code);
    }

    public static class ScriptParam
    implements Serializable {
        private static final long serialVersionUID = 4733248467785540711L;
        private ScriptType type;
        private String charset;
        private String script;
        private String[] envp;

        public ScriptType getType() {
            return this.type;
        }

        public String getCharset() {
            return this.charset;
        }

        public String getScript() {
            return this.script;
        }

        public String[] getEnvp() {
            return this.envp;
        }

        public void setType(ScriptType type) {
            this.type = type;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public void setEnvp(String[] envp) {
            this.envp = envp;
        }
    }

    public static enum ScriptType {
        CMD{

            @Override
            public void check() {
                Assert.isTrue((boolean)SystemUtils.IS_OS_WINDOWS, () -> "Command script cannot supported os '" + SystemUtils.OS_NAME + "'");
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("cmd_%d.bat", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws IOException {
                return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", scriptPath}, envp);
            }
        }
        ,
        POWERSHELL{

            @Override
            public void check() {
                Assert.isTrue((boolean)SystemUtils.IS_OS_WINDOWS, () -> "Powershell script cannot supported os '" + SystemUtils.OS_NAME + "'");
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("powershell_%d.ps1", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws IOException {
                return Runtime.getRuntime().exec(new String[]{"powershell.exe", scriptPath}, envp);
            }
        }
        ,
        SHELL{

            @Override
            public void check() {
                Assert.isTrue((!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0, () -> "Shell script cannot supported windows os '" + SystemUtils.OS_NAME + "'");
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("shell_%d.sh", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws Exception {
                ScriptJobHandler.chmodFile(scriptPath);
                return Runtime.getRuntime().exec(new String[]{"/bin/sh", scriptPath}, envp);
            }
        }
        ,
        PYTHON{

            @Override
            public void check() {
            }

            @Override
            public String buildFileName(long taskId) {
                return String.format("python_%d.py", taskId);
            }

            @Override
            public Process exec(String scriptPath, String[] envp) throws Exception {
                if (!SystemUtils.IS_OS_WINDOWS) {
                    ScriptJobHandler.chmodFile(scriptPath);
                }
                return Runtime.getRuntime().exec(new String[]{"python", scriptPath}, envp);
            }
        };


        public abstract void check();

        public abstract String buildFileName(long var1);

        public abstract Process exec(String var1, String[] var2) throws Exception;
    }
}

