/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.base.Server;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.springframework.util.Assert;

@JsonSerialize(using=JacksonSerializer.class)
@JsonDeserialize(using=JacksonDeserializer.class)
public class Supervisor
extends Server {
    private static final long serialVersionUID = -1254559108807415145L;
    private final transient String serializedValue;

    public Supervisor(String host, int port) {
        super(host, port);
        Assert.isTrue((!host.contains(":") ? 1 : 0) != 0, (String)"Host cannot contains symbol ':'");
        this.serializedValue = host + ":" + port;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    @Override
    public String serialize() {
        return this.serializedValue;
    }

    public static Supervisor deserialize(String text) {
        Assert.hasText((String)text, (String)"Serialized text cannot empty.");
        Object[] array = text.split(":");
        String host = (String)Collects.get((Object[])array, (int)0);
        Assert.hasText((String)host, (String)"Supervisor host cannot bank.");
        int port = Numbers.toInt((Object)Collects.get((Object[])array, (int)1));
        return new Supervisor(host, port);
    }

    public static Current current() {
        return Current.instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Supervisor && super.equals(o);
    }

    public boolean sameSupervisor(Supervisor other) {
        return super.sameServer(other);
    }

    public static abstract class Current
    extends Supervisor {
        private static final long serialVersionUID = -239845054171219365L;
        private static volatile Current instance = null;
        private final LocalDateTime startupAt;

        private Current(String host, int port) {
            super(host, port);
            SingletonClassConstraint.constrain(Current.class);
            this.startupAt = LocalDateTime.now();
        }

        public final LocalDateTime getStartupAt() {
            return this.startupAt;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public abstract String getWorkerContextPath(String var1);

        private static synchronized Current create(String host, int port, final UnaryOperator<String> workerContextPath) {
            if (instance != null) {
                throw new Error("Current supervisor already set.");
            }
            instance = new Current(host, port){
                private static final long serialVersionUID = 3856221643026735022L;

                @Override
                public String getWorkerContextPath(String group) {
                    return (String)workerContextPath.apply(group);
                }
            };
            return instance;
        }
    }

    public static class JacksonDeserializer
    extends JsonDeserializer<Supervisor> {
        public Supervisor deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Supervisor.deserialize(p.getText());
        }
    }

    public static class JacksonSerializer
    extends JsonSerializer<Supervisor> {
        public void serialize(Supervisor value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.serialize());
            }
        }
    }
}

