/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.core.enums.RunState;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum ExecuteState implements IntValueEnum<ExecuteState>
{
    WAITING(10, RunState.WAITING, "\u7b49\u5f85\u6267\u884c"),
    EXECUTING(20, RunState.RUNNING, "\u6b63\u5728\u6267\u884c"),
    PAUSED(30, RunState.PAUSED, "\u6682\u505c\u6267\u884c"),
    FINISHED(40, RunState.FINISHED, "\u6267\u884c\u5b8c\u6210"),
    DISPATCH_FAILED(50, RunState.CANCELED, "\u6d3e\u53d1\u5931\u8d25"),
    INSTANCE_FAILED(51, RunState.CANCELED, "\u5b9e\u4f8b\u5316\u5f02\u5e38"),
    VERIFY_FAILED(52, RunState.CANCELED, "\u6821\u9a8c\u5931\u8d25"),
    INIT_EXCEPTION(53, RunState.CANCELED, "\u521d\u59cb\u5316\u5f02\u5e38"),
    EXECUTE_FAILED(54, RunState.CANCELED, "\u6267\u884c\u5931\u8d25"),
    EXECUTE_EXCEPTION(55, RunState.CANCELED, "\u6267\u884c\u5f02\u5e38"),
    EXECUTE_TIMEOUT(56, RunState.CANCELED, "\u6267\u884c\u8d85\u65f6"),
    EXECUTE_COLLIDED(57, RunState.CANCELED, "\u6267\u884c\u51b2\u7a81"),
    MANUAL_CANCELED(58, RunState.CANCELED, "\u624b\u52a8\u53d6\u6d88"),
    BROADCAST_ABORTED(59, RunState.CANCELED, "\u5e7f\u64ad\u672a\u6267\u884c");

    private final int value;
    private final RunState runState;
    private final String desc;

    private ExecuteState(int value, RunState runState, String desc) {
        this.value = value;
        this.runState = runState;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public boolean isTerminal() {
        return this.runState.isTerminal();
    }

    public boolean isFailure() {
        return this.runState.isFailure();
    }

    public RunState runState() {
        return this.runState;
    }

    public static ExecuteState of(Integer value) {
        return (ExecuteState)((Object)Objects.requireNonNull(Const.MAPPING.get(value), () -> "Invalid execute state value: " + value));
    }

    public static final class Const {
        private static final Map<Integer, ExecuteState> MAPPING = Enums.toMap(ExecuteState.class, ExecuteState::value);
        public static final List<ExecuteState> PAUSABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)EXECUTING));
        public static final List<ExecuteState> EXECUTABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)PAUSED));
        public static final List<ExecuteState> TERMINABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)EXECUTING), (Object)((Object)PAUSED));
    }
}

