/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.model;

import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.core.enums.RunState;
import java.beans.Transient;

public class SchedWorkflow
extends BaseEntity {
    private static final long serialVersionUID = 3485414559751420216L;
    private Long wnstanceId;
    private String curNode;
    private String preNode;
    private Integer sequence;
    private Integer runState;
    private Long instanceId;

    public SchedWorkflow(Long wnstanceId, String curNode, String preNode, int sequence) {
        this.wnstanceId = wnstanceId;
        this.curNode = curNode;
        this.preNode = preNode;
        this.sequence = sequence;
        this.runState = RunState.WAITING.value();
    }

    public DAGEdge toEdge() {
        return DAGEdge.of((String)this.preNode, (String)this.curNode);
    }

    @Transient
    public boolean isTerminal() {
        return RunState.of(this.runState).isTerminal();
    }

    @Transient
    public boolean isFailure() {
        return RunState.of(this.runState).isFailure();
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public String getCurNode() {
        return this.curNode;
    }

    public String getPreNode() {
        return this.preNode;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public Integer getRunState() {
        return this.runState;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    public void setCurNode(String curNode) {
        this.curNode = curNode;
    }

    public void setPreNode(String preNode) {
        this.preNode = preNode;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public void setRunState(Integer runState) {
        this.runState = runState;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public SchedWorkflow() {
    }
}

