/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.model;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.model.AbstractExecutionTask;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.model.SchedWorkflow;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class WorkflowPredecessorNode
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 422243686633743869L;
    private long instanceId;
    private int sequence;
    private String curNode;
    private RunState runState;
    private List<ExecutedTask> executedTasks;

    public static WorkflowPredecessorNode of(SchedWorkflow workflow, List<SchedTask> tasks) {
        WorkflowPredecessorNode node = new WorkflowPredecessorNode();
        node.setInstanceId(workflow.getInstanceId());
        node.setSequence(workflow.getSequence());
        node.setCurNode(workflow.getCurNode());
        node.setRunState(RunState.of(workflow.getRunState()));
        node.setExecutedTasks(WorkflowPredecessorNode.convert(tasks));
        return node;
    }

    private static List<ExecutedTask> convert(List<SchedTask> tasks) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(WorkflowPredecessorNode::convert).collect(Collectors.toList());
    }

    private static ExecutedTask convert(SchedTask source) {
        if (source == null) {
            return null;
        }
        ExecutedTask target = new ExecutedTask();
        target.setTaskId(source.getTaskId());
        target.setTaskNo(source.getTaskNo());
        target.setTaskCount(source.getTaskCount());
        target.setExecuteSnapshot(source.getExecuteSnapshot());
        target.setExecuteState(ExecuteState.of(source.getExecuteState()));
        return target;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getCurNode() {
        return this.curNode;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public List<ExecutedTask> getExecutedTasks() {
        return this.executedTasks;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public void setCurNode(String curNode) {
        this.curNode = curNode;
    }

    public void setRunState(RunState runState) {
        this.runState = runState;
    }

    public void setExecutedTasks(List<ExecutedTask> executedTasks) {
        this.executedTasks = executedTasks;
    }

    public static class ExecutedTask
    extends AbstractExecutionTask {
        private static final long serialVersionUID = -4625053001297718912L;
        private ExecuteState executeState;

        public ExecuteState getExecuteState() {
            return this.executeState;
        }

        public void setExecuteState(ExecuteState executeState) {
            this.executeState = executeState;
        }
    }
}

