/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.util;

import cn.ponfee.disjob.common.util.NetUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisjobUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DisjobUtils.class);

    public static String getLocalHost(String specifiedHost) {
        String host = specifiedHost;
        if (DisjobUtils.isValidHost(host, "specified")) {
            return host;
        }
        host = System.getProperty("disjob.bound.server.host");
        if (DisjobUtils.isValidHost(host, "System#getProperty")) {
            return host;
        }
        host = System.getenv("disjob.bound.server.host");
        if (DisjobUtils.isValidHost(host, "System#getenv")) {
            return host;
        }
        host = NetUtils.getLocalHost();
        if (DisjobUtils.isValidHost(host, "NetUtils#getLocalHost")) {
            return host;
        }
        throw new Error("Not found available server host.");
    }

    private static boolean isValidHost(String host, String from) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return false;
        }
        if (!NetUtils.isValidLocalHost((String)host)) {
            LOG.warn("Invalid server host configured {}: {}", (Object)from, (Object)host);
            return false;
        }
        if (!NetUtils.isReachableHost((String)host)) {
            LOG.warn("Unreachable server host configured {}: {}", (Object)from, (Object)host);
        }
        return true;
    }
}

