/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.spring.RestTemplateUtils;
import cn.ponfee.disjob.common.spring.RpcControllerConfigurer;
import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.core.base.HttpProperties;
import cn.ponfee.disjob.core.base.RetryProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

public class DisjobCoreDeferredImportSelector
implements DeferredImportSelector {
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        return new String[]{DisjobCoreDeferredConfiguration.class.getName()};
    }

    private static class DisjobCoreDeferredConfiguration {
        private DisjobCoreDeferredConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public SpringContextHolder springContextHolder() {
            return new SpringContextHolder();
        }

        @ConditionalOnMissingBean
        @Bean
        public RetryProperties retryProperties() {
            return new RetryProperties();
        }

        @ConditionalOnMissingBean
        @Bean
        public HttpProperties httpProperties() {
            return new HttpProperties();
        }

        @ConditionalOnMissingBean(name={"disjob.bean.rest-template"})
        @Bean(value={"disjob.bean.rest-template"})
        public RestTemplate restTemplate(HttpProperties http, @Nullable ObjectMapper objectMapper) {
            http.check();
            return RestTemplateUtils.create((int)http.getConnectTimeout(), (int)http.getReadTimeout(), (ObjectMapper)objectMapper);
        }

        @ConditionalOnMissingBean
        @Bean
        public RpcControllerConfigurer rpcControllerConfigurer() {
            return new RpcControllerConfigurer();
        }
    }
}

