/*
 * Copyright 2022-2024 Ponfee (http://www.ponfee.cn/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.ponfee.disjob.core.dto.worker;

import lombok.Getter;
import lombok.Setter;

/**
 * Get worker metrics param
 *
 * @author Ponfee
 */
@Getter
@Setter
public class GetMetricsParam extends AuthenticationParam {
    private static final long serialVersionUID = 6100003437491314940L;

    public static GetMetricsParam of(String group) {
        GetMetricsParam param = new GetMetricsParam();
        param.fillSupervisorAuthenticationToken(group);
        return param;
    }
}
