/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.spring.RestTemplateUtils;
import cn.ponfee.disjob.common.spring.RpcControllerConfigurer;
import cn.ponfee.disjob.common.spring.SpringContextHolder;
import cn.ponfee.disjob.core.base.ControllerExceptionHandler;
import cn.ponfee.disjob.core.base.HttpProperties;
import cn.ponfee.disjob.core.base.JacksonDateConfigurer;
import cn.ponfee.disjob.core.base.RetryProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

public class BasicDeferredImportSelector
implements DeferredImportSelector {
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        return new String[]{BasicDeferredConfiguration.class.getName()};
    }

    @EnableConfigurationProperties(value={HttpProperties.class, RetryProperties.class})
    private static class BasicDeferredConfiguration {
        private static final String DATE_CONFIGURER_KEY = "disjob.jackson.date-configurer.mode";

        private BasicDeferredConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public SpringContextHolder springContextHolder() {
            return new SpringContextHolder();
        }

        @ConditionalOnMissingBean(name={"disjob.bean.rest-template"})
        @Bean(value={"disjob.bean.rest-template"})
        public RestTemplate restTemplate(HttpProperties http, @Nullable ObjectMapper objectMapper) {
            http.check();
            return RestTemplateUtils.create((int)http.getConnectTimeout(), (int)http.getReadTimeout(), (ObjectMapper)objectMapper);
        }

        @ConditionalOnMissingBean
        @Bean
        public RpcControllerConfigurer rpcControllerConfigurer() {
            return new RpcControllerConfigurer();
        }

        @ConditionalOnProperty(name={"disjob.jackson.date-configurer.mode"}, havingValue="multiple")
        @Bean
        public JacksonDateConfigurer.Multiple multipleJacksonDateConfigurer(List<ObjectMapper> list) {
            return new JacksonDateConfigurer.Multiple(list);
        }

        @ConditionalOnProperty(name={"disjob.jackson.date-configurer.mode"}, havingValue="primary", matchIfMissing=true)
        @Bean
        public JacksonDateConfigurer.Primary primaryJacksonDateConfigurer(@Nullable ObjectMapper objectMapper) {
            return new JacksonDateConfigurer.Primary(objectMapper);
        }

        @ConditionalOnExpression(value="${disjob.controller.exception-handler.enabled:true}")
        @Order(value=0)
        @Bean
        public ControllerExceptionHandler controllerExceptionHandler() {
            return new ControllerExceptionHandler();
        }
    }
}

