/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.util.Strings;
import java.io.Serializable;
import org.springframework.util.Assert;

public abstract class Server
implements Serializable {
    private static final long serialVersionUID = -783308216490505598L;
    protected final String host;
    protected final int port;

    protected Server(String host, int port) {
        Assert.isTrue((0 < port && port <= 65535 ? 1 : 0) != 0, (String)"Port must be range (0, 65535].");
        this.host = Server.check(host);
        this.port = port;
    }

    public abstract int hashCode();

    public boolean equals(Object obj) {
        if (!(obj instanceof Server)) {
            return false;
        }
        Server that = (Server)obj;
        return this.host.equals(that.host) && this.port == that.port;
    }

    public final String toString() {
        return this.serialize();
    }

    public abstract String serialize();

    public final String buildHttpUrlPrefix() {
        return "http://" + this.host + ":" + this.port;
    }

    public final String buildHttpsUrlPrefix() {
        return "https://" + this.host + ":" + this.port;
    }

    static String check(String str) {
        if (str == null || str.isEmpty() || Strings.containsCharOrWhitespace((String)str, (char)':')) {
            throw new IllegalArgumentException("Invalid server part value: " + (str == null ? "null" : "'" + str + "'"));
        }
        return str;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

