/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.dto.worker;

import cn.ponfee.disjob.core.dto.worker.AuthenticationParam;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;

public class SplitJobParam
extends AuthenticationParam {
    private static final long serialVersionUID = -216622646271234535L;
    private String group;
    private String jobHandler;
    private String jobParam;
    private JobType jobType;
    private RouteStrategy routeStrategy;

    public SplitJobParam(String group, String jobHandler, String jobParam, JobType jobType, RouteStrategy routeStrategy) {
        this.group = group;
        this.jobHandler = jobHandler;
        this.jobParam = jobParam;
        this.jobType = jobType;
        this.routeStrategy = routeStrategy;
    }

    public static SplitJobParam from(SchedJob job, SchedInstance instance) {
        if (instance.isWorkflowLead()) {
            throw new IllegalArgumentException("Split job cannot workflow lead instance: " + instance.getInstanceId());
        }
        String jobHandler = instance.isWorkflowNode() ? instance.parseAttach().parseCurrentNode().getName() : job.getJobHandler();
        return SplitJobParam.from(job, jobHandler);
    }

    public static SplitJobParam from(SchedJob job, String jobHandler) {
        return new SplitJobParam(job.getGroup(), jobHandler, job.getJobParam(), JobType.of(job.getJobType()), RouteStrategy.of(job.getRouteStrategy()));
    }

    public String getGroup() {
        return this.group;
    }

    public String getJobHandler() {
        return this.jobHandler;
    }

    public String getJobParam() {
        return this.jobParam;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public RouteStrategy getRouteStrategy() {
        return this.routeStrategy;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobHandler(String jobHandler) {
        this.jobHandler = jobHandler;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setRouteStrategy(RouteStrategy routeStrategy) {
        this.routeStrategy = routeStrategy;
    }

    public SplitJobParam() {
    }
}

