/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.core.enums.Operation;
import java.util.Map;
import java.util.Objects;

public enum RedeployStrategy implements IntValueEnum<RedeployStrategy>
{
    RESUME(1, Operation.SHUTDOWN_RESUME, "\u6062\u590d\u6267\u884c"),
    PAUSE(2, Operation.SHUTDOWN_PAUSE, "\u6682\u505c\u6267\u884c"),
    CANCEL(3, Operation.SHUTDOWN_CANCEL, "\u53d6\u6d88\u6267\u884c");

    private final int value;
    private final Operation operation;
    private final String desc;

    private RedeployStrategy(int value, Operation operation, String desc) {
        this.value = value;
        this.operation = operation;
        this.desc = desc;
    }

    public int value() {
        return this.value;
    }

    public String desc() {
        return this.desc;
    }

    public Operation operation() {
        return this.operation;
    }

    public static RedeployStrategy of(Integer value) {
        return (RedeployStrategy)((Object)Objects.requireNonNull(Const.MAPPING.get(value), () -> "Invalid redeploy strategy value: " + value));
    }

    private static final class Const {
        private static final Map<Integer, RedeployStrategy> MAPPING = Enums.toMap(RedeployStrategy.class, RedeployStrategy::value);

        private Const() {
        }
    }
}

