/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.base;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.base.Server;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.springframework.util.Assert;

@JsonSerialize(using=JacksonSerializer.class)
@JsonDeserialize(using=JacksonDeserializer.class)
public class Supervisor
extends Server {
    private static final long serialVersionUID = -1254559108807415145L;
    private final transient String serializedValue;

    public Supervisor(String host, int port) {
        super(host, port);
        this.serializedValue = this.host + ":" + this.port;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    @Override
    public final String serialize() {
        return this.serializedValue;
    }

    public static Supervisor deserialize(String text) {
        Assert.hasText((String)text, (String)"Serialized text cannot empty.");
        Object[] array = text.split(":");
        String host = (String)Collects.get((Object[])array, (int)0);
        Assert.hasText((String)host, (String)"Supervisor host cannot bank.");
        int port = Numbers.toInt((Object)Collects.get((Object[])array, (int)1));
        return new Supervisor(host, port);
    }

    public static Local local() {
        return Local.instance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Supervisor && super.equals(o);
    }

    public static abstract class Local
    extends Supervisor {
        private static volatile Local instance = null;
        private final LocalDateTime startupTime;

        private Local(String host, int port) {
            super(host, port);
            SingletonClassConstraint.constrain(Local.class);
            this.startupTime = LocalDateTime.now();
        }

        public final LocalDateTime getStartupTime() {
            return this.startupTime;
        }

        public abstract String getWorkerContextPath(String var1);

        private static synchronized Local create(String host, int port, final UnaryOperator<String> workerContextPath) {
            if (instance != null) {
                throw new Error("Local supervisor already created.");
            }
            instance = new Local(host, port){

                @Override
                public String getWorkerContextPath(String group) {
                    return (String)workerContextPath.apply(group);
                }
            };
            return instance;
        }
    }

    public static class JacksonDeserializer
    extends JsonDeserializer<Supervisor> {
        public Supervisor deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            return Supervisor.deserialize(p.getText());
        }
    }

    public static class JacksonSerializer
    extends JsonSerializer<Supervisor> {
        public void serialize(Supervisor value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.serialize());
            }
        }
    }
}

