/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.dto.supervisor;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.JobType;
import java.io.Serializable;
import org.springframework.util.Assert;

public class StartTaskParam
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 7700836087189718161L;
    private long jobId;
    private Long wnstanceId;
    private long instanceId;
    private long taskId;
    private String worker;
    private String startRequestId;
    private JobType jobType;

    public StartTaskParam(long jobId, Long wnstanceId, long instanceId, long taskId, JobType jobType, Worker worker, String startRequestId) {
        this.jobId = jobId;
        this.wnstanceId = wnstanceId;
        this.instanceId = instanceId;
        this.taskId = taskId;
        this.jobType = jobType;
        this.worker = worker.serialize();
        this.startRequestId = startRequestId;
    }

    public void check() {
        Assert.hasText((String)this.worker, (String)"Start task worker cannot be empty.");
        Assert.hasText((String)this.startRequestId, (String)"Start request id cannot be empty.");
        Assert.notNull((Object)((Object)this.jobType), (String)"Job type cannot be empty.");
    }

    public long getJobId() {
        return this.jobId;
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public long getInstanceId() {
        return this.instanceId;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String getWorker() {
        return this.worker;
    }

    public String getStartRequestId() {
        return this.startRequestId;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    public void setInstanceId(long instanceId) {
        this.instanceId = instanceId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public void setStartRequestId(String startRequestId) {
        this.startRequestId = startRequestId;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public StartTaskParam() {
    }
}

