/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.dto.worker;

import cn.ponfee.disjob.core.dto.worker.AuthenticationParam;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;

public class SplitJobParam
extends AuthenticationParam {
    private static final long serialVersionUID = -216622646271234535L;
    private String group;
    private String jobExecutor;
    private String jobParam;
    private JobType jobType;
    private RouteStrategy routeStrategy;

    public SplitJobParam(String group, String jobExecutor, String jobParam, JobType jobType, RouteStrategy routeStrategy) {
        this.group = group;
        this.jobExecutor = jobExecutor;
        this.jobParam = jobParam;
        this.jobType = jobType;
        this.routeStrategy = routeStrategy;
    }

    public static SplitJobParam from(SchedJob job, SchedInstance instance) {
        if (instance.isWorkflowLead()) {
            throw new IllegalArgumentException("Split job cannot workflow lead instance: " + instance.getInstanceId());
        }
        String jobExecutor = instance.isWorkflowNode() ? instance.parseAttach().parseCurrentNode().getName() : job.getJobExecutor();
        return SplitJobParam.from(job, jobExecutor);
    }

    public static SplitJobParam from(SchedJob job, String jobExecutor) {
        return new SplitJobParam(job.getGroup(), jobExecutor, job.getJobParam(), JobType.of(job.getJobType()), RouteStrategy.of(job.getRouteStrategy()));
    }

    public String getGroup() {
        return this.group;
    }

    public String getJobExecutor() {
        return this.jobExecutor;
    }

    public String getJobParam() {
        return this.jobParam;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public RouteStrategy getRouteStrategy() {
        return this.routeStrategy;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobExecutor(String jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setJobParam(String jobParam) {
        this.jobParam = jobParam;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setRouteStrategy(RouteStrategy routeStrategy) {
        this.routeStrategy = routeStrategy;
    }

    public SplitJobParam() {
    }
}

